<?php

use App\Models\ConversationMessage;
use App\Models\ProductCategory;
use App\Models\Setting;
use App\Models\Lang;
use App\Models\LangSet;
use App\Models\SiteWord;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Cache;

if (!function_exists('parent_id')) {
    function parent_id($item, $cat)
    {
        if ($item->parent_null) {
            if ($cat == 1) {
                return $item->parent->parent->id;
            } elseif ($cat == 2) {
                return $item->parent->id;
            } else {
                return 'father';
            }
        } else {
            if ($cat == 1) {
                return $item->parent->parent->parent->id;
            } elseif ($cat == 2) {
                return $item->parent->parent->id;
            } else {
                return $item->parent->id;
            }
        }
    }
}
if (!function_exists('chat_count')) {
    function chat_count($user_id, $sender_id = null)
    {
        if ($sender_id) {
            $count = ConversationMessage::where('read', 0)->where('receiver_id', $user_id)->where('sender_id', $sender_id)->count();

            return $count;
        } else {
            $count = ConversationMessage::where('read', 0)->where('receiver_id', $user_id)->count();

            return $count;
        }
    }
}
if (!function_exists('parent_id2')) {
    function parent_id2($item, $cat)
    {
        if ($item->parent_null) {
            if ($cat == 2) {
                return $item->parent->parent_id;
            } else {
                return 'father';
            }
        } else {
            if ($cat == 2) {
                return $item->parent->parent->parent_id;
            } else {
                return $item->parent->parent_id;
            }
        }

    }
}
if (!function_exists('generateSlug')) {
    function generateSlug($title)
    {
        // تبدیل به حروف کوچک
        $slug = strtolower($title);

        // حذف کاراکترهای غیرمجاز
        $slug = preg_replace('/[^a-z0-9\-]/', '-', $slug);

        // جایگزینی فاصله‌ها با '-'
        $slug = preg_replace('/\s+/', '-', $slug);

        // حذف کاراکترهای اضافی '-'
        $slug = trim($slug, '-');

        return $slug;
    }
}

if (!function_exists('lang_admin')) {
    function lang_admin()
    {
        return session('admin-lang');
    }
}
if (!function_exists('dir_admin')) {
    function dir_admin()
    {
        return session('admin-dir');
    }
}
if (!function_exists('translateText3')) {
    function translateText3($text, $targetLang = 'fa')
    {
        if (lang_admin() == 'fa')
            return $text;
        // ایجاد یک کلید منحصر به فرد برای کش بر اساس متن و زبان هدف
        $cacheKey = 'translation_' . md5($text . '_' . $targetLang);

        // بررسی وجود نتیجه در کش
        if (Cache::has($cacheKey)) {
            return Cache::get($cacheKey);
        }

        $apiKey = 'AIzaSyBxTpyugfRjGo14M4dUh_BGH2RzjMeUnJI';
        // ایجاد URL برای درخواست API
        $url = 'https://translation.googleapis.com/language/translate/v2';

        // داده‌هایی که باید ارسال شوند
        $data = array(
            'q' => $text,
            'target' => $targetLang,
            'format' => 'text'
        );

        // تبدیل داده‌ها به فرمت JSON
        $dataString = json_encode($data);

        // تنظیمات cURL برای ارسال درخواست
        $ch = curl_init($url . '?key=' . $apiKey);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($dataString))
        );
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

        // دریافت پاسخ
        $response = curl_exec($ch);
        curl_close($ch);

//        dd($response);
        // تبدیل پاسخ به آرایه
        $responseArray = json_decode($response, true);
        // بررسی نتیجه و استخراج ترجمه
        if (isset($responseArray['data']['translations'][0]['translatedText'])) {
            $translatedText = $responseArray['data']['translations'][0]['translatedText'];
            // ذخیره نتیجه ترجمه در کش به مدت 24 ساعت (86400 ثانیه)
            Cache::put($cacheKey, $translatedText, 86400);

            return $translatedText;
        } else {
            return $text;
        }
    }
}
if (!function_exists('translateTextSave2')) {
    function translateTextSave2($text, $targetLang = 'fa')
    {
        $apiKey = 'AIzaSyBxTpyugfRjGo14M4dUh_BGH2RzjMeUnJI';
        // ایجاد URL برای درخواست API
        $url = 'https://translation.googleapis.com/language/translate/v2';

        // داده‌هایی که باید ارسال شوند
        $data = array(
            'q' => $text,
            'target' => $targetLang,
            'format' => 'text'
        );

        // تبدیل داده‌ها به فرمت JSON
        $dataString = json_encode($data);

        // تنظیمات cURL برای ارسال درخواست
        $ch = curl_init($url . '?key=' . $apiKey);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($dataString))
        );
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

        // دریافت پاسخ
        $response = curl_exec($ch);
        curl_close($ch);

        // تبدیل پاسخ به آرایه
        $responseArray = json_decode($response, true);
        // بررسی نتیجه و استخراج ترجمه
        if (isset($responseArray['data']['translations'][0]['translatedText'])) {
            return $responseArray['data']['translations'][0]['translatedText'];
        } else {
            return $text;
        }
    }
}
if (!function_exists('translateTextApi2')) {
    function translateTextApi2($text, $sourceLang = 'en', $targetLang = 'fa')
    {
        $apiKey = 'AIzaSyBxTpyugfRjGo14M4dUh_BGH2RzjMeUnJI';
        // ایجاد URL برای درخواست API
        $url = 'https://translation.googleapis.com/language/translate/v2';

        // داده‌هایی که باید ارسال شوند
        $data = array(
            'q' => $text,
            'source' => $sourceLang,
            'target' => $targetLang,
            'format' => 'text'
        );

        // تبدیل داده‌ها به فرمت JSON
        $dataString = json_encode($data);

        // تنظیمات cURL برای ارسال درخواست
        $ch = curl_init($url . '?key=' . $apiKey);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($dataString))
        );
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

        // دریافت پاسخ
        $response = curl_exec($ch);
        curl_close($ch);
        // تبدیل پاسخ به آرایه
        $responseArray = json_decode($response, true);
        // بررسی نتیجه و استخراج ترجمه
        if (isset($responseArray['data']['translations'][0]['translatedText'])) {
            return $responseArray['data']['translations'][0]['translatedText'];
        } else {
            return "خطا در ترجمه.";
        }
    }
}
if (!function_exists('translateText2')) {
    function translateText2($text, $sourceLang = 'en', $targetLang = 'fa')
    {
        // ایجاد URL برای API
        $url = 'https://translate.googleapis.com/translate_a/single?client=gtx&sl=' . $sourceLang . '&tl=' . $targetLang . '&dt=t&q=' . urlencode($text);

        // استفاده از cURL برای ارسال درخواست
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        curl_close($ch);

        // تبدیل پاسخ به آرایه
        $responseArray = json_decode($response, true);
        // استخراج ترجمه
        if (isset($responseArray[0][0][0])) {
            return $responseArray[0][0][0];
        } else {
            return "ترجمه‌ای یافت نشد.";
        }
    }
}
if (!function_exists('translateText')) {
    function translateText($text, $targetLang = 'fa')
    {
        if (lang_admin() == 'fa')
            return $text;
        // ایجاد یک کلید منحصر به فرد برای کش بر اساس متن و زبان هدف
        $cacheKey = 'translation_' . md5($text . '_' . $targetLang);

        // بررسی وجود نتیجه در کش
        if (Cache::has($cacheKey)) {
            return Cache::get($cacheKey);
        }

        // ایجاد URL برای API با تشخیص خودکار زبان منبع
        $url = 'https://translate.googleapis.com/translate_a/single?client=gtx&sl=auto&tl=' . $targetLang . '&dt=t&q=' . urlencode($text);

        // استفاده از cURL برای ارسال درخواست
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        curl_close($ch);

        // تبدیل پاسخ به آرایه
        $responseArray = json_decode($response, true);

        // استخراج ترجمه
        if (isset($responseArray[0][0][0])) {
            $translatedText = $responseArray[0][0][0];

            // ذخیره نتیجه ترجمه در کش به مدت 24 ساعت (86400 ثانیه)
            Cache::put($cacheKey, $translatedText, 86400);

            return $translatedText;
        } else {
            return $text;
        }
    }
}
if (!function_exists('translateTextSave')) {
    function translateTextSave($text, $targetLang = 'fa')
    {
        $url = 'https://translate.googleapis.com/translate_a/single?client=gtx&sl=auto&tl=' . $targetLang . '&dt=t&q=' . urlencode($text);

        // استفاده از cURL برای ارسال درخواست
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        curl_close($ch);

        // تبدیل پاسخ به آرایه
        $responseArray = json_decode($response, true);

        // استخراج ترجمه
        if (isset($responseArray[0][0][0])) {
            $translatedText = $responseArray[0][0][0];

            return $translatedText;
        } else {
            return $text;
        }
    }
}
if (!function_exists('login_bg')) {
    function login_bg()
    {
        $item = Setting::first();

        return $item && $item->login && is_file($item->login->path) ? url($item->login->path) : url('assets/front/img/login_bg.jpg');
    }
}
if (!function_exists('request_bg')) {
    function request_bg()
    {
        $item = Setting::first();

        return $item && $item->request_bg && is_file($item->request_bg->path) ? url($item->request_bg->path) : url('assets/front/img/login_bg.jpg');
    }
}
if (!function_exists('icon_svg')) {
    function icon_svg($type)
    {
        if ($type == 'category') {
            return '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-menu-button-fill" viewBox="0 0 16 16">
  <path d="M1.5 0A1.5 1.5 0 0 0 0 1.5v2A1.5 1.5 0 0 0 1.5 5h8A1.5 1.5 0 0 0 11 3.5v-2A1.5 1.5 0 0 0 9.5 0zm5.927 2.427A.25.25 0 0 1 7.604 2h.792a.25.25 0 0 1 .177.427l-.396.396a.25.25 0 0 1-.354 0zM0 8a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm1 3v2a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2zm14-1V8a1 1 0 0 0-1-1H2a1 1 0 0 0-1 1v2zM2 8.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5m0 4a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5"/>
</svg>';
        } elseif ($type == 'gmail') {
            return '<svg width="40" height="40" viewBox="0 0 32 32" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M30.0033 16.3114C30.0033 15.1603 29.908 14.3203 29.7018 13.4492H16.2891V18.6447H24.162C24.0033 19.9359 23.1462 21.8803 21.2414 23.1869L21.2147 23.3609L25.4555 26.5805L25.7494 26.6092C28.4477 24.167 30.0033 20.5736 30.0033 16.3114"
                                                  fill="#4285F4"></path>
                                            <path d="M16.2862 30C20.1433 30 23.3814 28.7555 25.7465 26.6089L21.2386 23.1865C20.0322 24.011 18.4132 24.5866 16.2862 24.5866C12.5085 24.5866 9.30219 22.1444 8.15923 18.7688L7.9917 18.7827L3.58202 22.1272L3.52435 22.2843C5.87353 26.8577 10.6989 30 16.2862 30Z"
                                                  fill="#34A853"></path>
                                            <path d="M8.15866 18.7699C7.85708 17.8988 7.68255 16.9654 7.68255 16.001C7.68255 15.0365 7.85708 14.1032 8.1428 13.2321L8.13481 13.0466L3.66986 9.64844L3.52377 9.71653C2.55556 11.6143 2 13.7455 2 16.001C2 18.2566 2.55556 20.3876 3.52377 22.2854L8.15866 18.7699"
                                                  fill="#FBBC05"></path>
                                            <path d="M16.2863 7.4133C18.9688 7.4133 20.7783 8.54885 21.8101 9.4978L25.8418 5.64C23.3657 3.38445 20.1434 2 16.2863 2C10.699 2 5.87354 5.1422 3.52435 9.71549L8.14339 13.2311C9.30223 9.85555 12.5086 7.4133 16.2863 7.4133"
                                                  fill="#EB4335"></path>
                                        </svg>';
        } elseif ($type == 'chat') {
            return '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-wechat" viewBox="0 0 16 16">
  <path d="M11.176 14.429c-2.665 0-4.826-1.8-4.826-4.018 0-2.22 2.159-4.02 4.824-4.02S16 8.191 16 10.411c0 1.21-.65 2.301-1.666 3.036a.32.32 0 0 0-.12.366l.218.81a.6.6 0 0 1 .029.117.166.166 0 0 1-.162.162.2.2 0 0 1-.092-.03l-1.057-.61a.5.5 0 0 0-.256-.074.5.5 0 0 0-.142.021 5.7 5.7 0 0 1-1.576.22M9.064 9.542a.647.647 0 1 0 .557-1 .645.645 0 0 0-.646.647.6.6 0 0 0 .09.353Zm3.232.001a.646.646 0 1 0 .546-1 .645.645 0 0 0-.644.644.63.63 0 0 0 .098.356"/>
  <path d="M0 6.826c0 1.455.781 2.765 2.001 3.656a.385.385 0 0 1 .143.439l-.161.6-.1.373a.5.5 0 0 0-.032.14.19.19 0 0 0 .193.193q.06 0 .111-.029l1.268-.733a.6.6 0 0 1 .308-.088q.088 0 .171.025a6.8 6.8 0 0 0 1.625.26 4.5 4.5 0 0 1-.177-1.251c0-2.936 2.785-5.02 5.824-5.02l.15.002C10.587 3.429 8.392 2 5.796 2 2.596 2 0 4.16 0 6.826m4.632-1.555a.77.77 0 1 1-1.54 0 .77.77 0 0 1 1.54 0m3.875 0a.77.77 0 1 1-1.54 0 .77.77 0 0 1 1.54 0"/>
</svg>';
        } elseif ($type == 'contact') {
            return '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
  <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z"/>
</svg>';
        } elseif ($type == 'check_circle') {
            return '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check2-circle" viewBox="0 0 16 16">
  <path d="M2.5 8a5.5 5.5 0 0 1 8.25-4.764.5.5 0 0 0 .5-.866A6.5 6.5 0 1 0 14.5 8a.5.5 0 0 0-1 0 5.5 5.5 0 1 1-11 0"/>
  <path d="M15.354 3.354a.5.5 0 0 0-.708-.708L8 9.293 5.354 6.646a.5.5 0 1 0-.708.708l3 3a.5.5 0 0 0 .708 0z"/>
</svg>';
        } elseif ($type == 'rfq') {
            return '<svg version="1.0" xmlns="http://www.w3.org/2000/svg"
 width="30px" height="25px" viewBox="0 0 512.000000 389.000000"
 preserveAspectRatio="xMidYMid meet">

<g transform="translate(0.000000,389.000000) scale(0.100000,-0.100000)"
fill="#000000" stroke="none">
<path d="M2175 3814 c-289 -20 -368 -27 -485 -40 -474 -53 -1157 -194 -1323
-273 -128 -61 -246 -183 -308 -317 -61 -133 -60 -115 -57 -1274 4 -1179 -2
-1083 76 -1235 49 -95 171 -217 270 -268 128 -67 594 -176 1052 -246 663 -101
1397 -112 2095 -30 313 36 629 94 955 174 217 53 229 58 255 93 31 42 25 99
-14 134 -43 38 -68 37 -279 -17 -371 -93 -742 -156 -1177 -200 -388 -39 -1006
-35 -1445 10 -484 50 -1166 188 -1337 270 -125 61 -213 182 -233 323 -13 90
-13 1964 0 2057 20 144 109 269 233 329 112 55 623 170 997 225 414 61 632 76
1110 76 492 0 705 -15 1145 -81 342 -52 838 -163 953 -215 123 -55 219 -182
241 -320 7 -41 11 -417 11 -1057 l0 -994 34 -34 c47 -47 95 -47 142 0 l34 34
0 1024 c0 1145 2 1099 -72 1248 -33 67 -59 102 -123 165 -111 110 -180 143
-431 206 -431 108 -819 174 -1278 215 -159 15 -909 27 -1041 18z"/>
<path d="M500 1950 l0 -870 170 0 170 0 0 290 0 291 122 -3 122 -3 206 -287
205 -287 362 0 363 -1 2 343 3 342 272 3 271 2 7 -32 c29 -133 130 -301 248
-415 167 -160 372 -243 601 -243 137 0 126 -16 126 185 l0 172 -94 -5 c-167
-8 -287 37 -402 152 -329 329 -98 888 366 888 236 0 436 -152 504 -382 17 -56
23 -195 10 -244 l-6 -26 178 2 179 3 -1 140 c0 157 -14 222 -69 342 -93 201
-237 345 -438 438 -129 59 -184 70 -362 69 -147 0 -167 -3 -245 -28 -101 -33
-195 -81 -268 -136 -29 -22 -55 -40 -57 -40 -3 0 -5 47 -5 105 l0 105 -580 0
-580 0 0 -806 c0 -490 -4 -804 -9 -802 -10 3 -411 505 -411 513 0 3 17 16 38
29 56 35 139 123 177 188 100 169 104 396 12 573 -43 84 -165 203 -248 243
-121 59 -146 62 -561 62 l-378 0 0 -870z m705 519 c140 -26 221 -148 194 -292
-12 -64 -31 -99 -79 -139 -59 -51 -95 -58 -299 -58 l-181 0 0 243 c0 134 3
247 7 250 11 11 294 8 358 -4z m1715 6 c0 -2 -18 -32 -39 -65 -40 -62 -93
-186 -105 -250 -16 -77 13 -70 -287 -70 l-269 0 0 188 c0 104 3 192 7 195 7 8
693 10 693 2z"/>
<path d="M3556 2009 c-53 -62 -48 -70 179 -299 l205 -207 0 -189 0 -189 153
-153 c84 -83 156 -152 160 -152 4 0 7 113 7 250 l0 250 247 0 248 0 -160 160
-160 160 -184 0 -185 0 -201 200 c-196 194 -203 200 -243 200 -33 0 -45 -6
-66 -31z"/>
</g>
</svg>';
        } elseif ($type == 'sign-in') {
            return '<svg xmlns="http://www.w3.org/2000/svg" width="30" height="25" viewBox="0 0 16 16"><path fill="currentColor" d="M11 7c0 1.66-1.34 3-3 3S5 8.66 5 7s1.34-3 3-3s3 1.34 3 3"/><path fill="currentColor" fill-rule="evenodd" d="M16 8c0 4.42-3.58 8-8 8s-8-3.58-8-8s3.58-8 8-8s8 3.58 8 8M4 13.75C4.16 13.484 5.71 11 7.99 11c2.27 0 3.83 2.49 3.99 2.75A6.98 6.98 0 0 0 14.99 8c0-3.87-3.13-7-7-7s-7 3.13-7 7c0 2.38 1.19 4.49 3.01 5.75" clip-rule="evenodd"/></svg>';
        } elseif ($type == 'messages') {
            return '<svg version="1.0" xmlns="http://www.w3.org/2000/svg"
 width="30px" height="25px" viewBox="0 0 500.000000 500.000000"
 preserveAspectRatio="xMidYMid meet">

<g transform="translate(0.000000,500.000000) scale(0.100000,-0.100000)"
fill="#000000" stroke="none">
<path d="M2325 4994 c-438 -43 -767 -147 -1108 -348 -320 -188 -652 -517 -850
-841 -341 -560 -448 -1221 -302 -1865 201 -894 915 -1631 1796 -1855 440 -112
878 -109 1309 9 757 207 1387 784 1666 1522 190 504 213 1032 69 1559 -157
574 -531 1084 -1040 1418 -300 197 -665 333 -1025 383 -103 14 -436 26 -515
18z m449 -89 c542 -63 1048 -308 1431 -690 521 -519 777 -1239 700 -1965 -59
-556 -301 -1065 -695 -1460 -947 -946 -2476 -945 -3424 4 -194 194 -333 389
-457 641 -646 1314 14 2896 1404 3360 332 111 700 150 1041 110z"/>
<path d="M922 3498 c-19 -19 -17 -1981 2 -1997 10 -8 431 -10 1582 -9 l1569 3
0 1005 0 1005 -1570 3 c-1214 1 -1574 -1 -1583 -10z m2947 -130 c-111 -88
-910 -723 -1197 -952 -156 -124 -175 -136 -190 -123 -9 8 -150 120 -312 248
-162 129 -403 321 -535 426 -132 105 -323 256 -424 337 l-184 146 1473 0 1473
0 -104 -82z m-2649 -144 c124 -98 322 -255 440 -349 118 -94 270 -214 337
-267 66 -53 124 -101 127 -106 3 -5 -159 -139 -360 -298 -451 -356 -607 -479
-741 -584 l-53 -41 0 922 c0 736 3 919 13 912 6 -6 113 -90 237 -189z m2810
-720 c0 -801 -2 -915 -15 -911 -8 4 -241 185 -517 403 -277 219 -531 419 -565
447 -35 27 -63 52 -63 55 1 4 87 75 193 159 106 83 365 289 576 457 211 168
386 306 387 306 2 0 4 -412 4 -916z m-1697 -164 c83 -66 158 -120 167 -120 8
0 80 52 160 116 80 64 148 118 152 120 4 3 95 -64 201 -148 107 -84 365 -288
574 -453 l380 -300 -734 -3 c-403 -1 -1063 -1 -1467 0 l-734 3 285 225 c156
124 414 327 571 452 158 125 289 227 290 227 2 1 72 -53 155 -119z"/>
</g>
</svg>';
        } elseif ($type == 'search-circle') {
            return '<svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" class="search-circle" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" color="currentColor"><path d="M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12s4.477 10 10 10s10-4.477 10-10"/><path d="M14.4 14.4L16 16m-.8-4.4a3.6 3.6 0 1 0-7.2 0a3.6 3.6 0 0 0 7.2 0"/></g></svg>';
        } elseif ($type == 'close-circle-d-none') {
            return '<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" class="close-circle d-none" viewBox="0 0 32 32"><path fill="currentColor" d="M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14s14-6.2 14-14S23.8 2 16 2m0 26C9.4 28 4 22.6 4 16S9.4 4 16 4s12 5.4 12 12s-5.4 12-12 12"/><path fill="currentColor" d="M21.4 23L16 17.6L10.6 23L9 21.4l5.4-5.4L9 10.6L10.6 9l5.4 5.4L21.4 9l1.6 1.6l-5.4 5.4l5.4 5.4z"/></svg>';
        }
    }
}
if (!function_exists('photo_alt')) {
    function photo_alt($item, $real, $alt)
    {
        if ($item->$real && !blank($item->$real->alt)) {
            $alt = $item->$real->alt;
        }
        return $alt;
    }
}
if (!function_exists('captcha')) {
    function captcha()
    {
        header('Content-type: image/jpeg');
        $image_name = rand(100, 120);
        $string = rand(1000, 9999);
        session(['captcha_code' => $string]);
        $font_size = 30;
        $img_width = 150;
        $img_height = 40;

        $image = imagecreate($img_width, $img_height); // create background image with dimensions
        imagecolorallocate($image, 255, 255, 255); // set background color
        $text_color = imagecolorallocate($image, 0, 0, 0); // set captcha text color
        imagettftext($image, $font_size, 0, 15, 30, $text_color, 'Vazir-Bold.ttf', $string);
        $image_name = 'captcha' . '/' . $image_name . '.png';
        imagejpeg($image, $image_name);
        imagedestroy($image);
        return $image_name;
//            return 44;
    }
}
if (!function_exists('captcha2')) {
    function captcha2()
    {
        header('Content-type: image/jpeg');
        $image_name = rand(120, 140);
        $string = rand(1000, 9999);
        session(['captcha_code2' => $string]);
        $font_size = 30;
        $img_width = 150;
        $img_height = 40;

        $image = imagecreate($img_width, $img_height); // create background image with dimensions
        imagecolorallocate($image, 255, 255, 255); // set background color
        $text_color = imagecolorallocate($image, 0, 0, 0); // set captcha text color
        imagettftext($image, $font_size, 0, 15, 30, $text_color, 'Vazir-Bold.ttf', $string);
        $image_name = 'captcha' . '/' . $image_name . '.png';
        imagejpeg($image, $image_name);
        imagedestroy($image);
        return $image_name;
//            return 44;
    }
}

if (!function_exists('optimize_img')) {
    function optimize_img($path)
    {
        $WEBSERVICE = 'http://api.resmush.it/ws.php?img=';
        $optimized_png_arr = json_decode(file_get_contents($WEBSERVICE . urlencode(url($path))));

        if (isset($optimized_png_arr->dest)) {
            $optimized_png_url = $optimized_png_arr->dest;

            $fp = fopen($path, 'w+');

            $ch = curl_init($optimized_png_url);
            curl_setopt($ch, CURLOPT_FILE, $fp);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_TIMEOUT, 1000);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla5.0');
            curl_exec($ch);

            curl_close($ch);
            fclose($fp);
        }
    }
}

if (!function_exists('ip_address')) {
    function ip_address()
    {
        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if (getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if (getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if (getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if (getenv('HTTP_FORWARDED'))
            $ipaddress = getenv('HTTP_FORWARDED');
        else if (getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }
}

if (!function_exists('isFile')) {
    function isFile($url)
    {

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_NOBODY, true);
        curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if ($code == 200) {
            $status = true;
        } else {
            $status = false;
        }
        curl_close($ch);
        return $status;
    }
}


if (!function_exists('default_lang')) {
    function default_lang()
    {
        return LangSet::where('status', 'default')->firstOrFail()->lang;
    }
}
if (!function_exists('dir_set')) {
    function dir_set()
    {
        return LangSet::where('lang', app()->getLocale())->firstOrFail()->align;
    }
}
if (!function_exists('font_farsi')) {
    function font_farsi()
    {
        return LangSet::where('lang', app()->getLocale())->firstOrFail()->farsi_font;
    }
}

if (!function_exists('tab_langs')) {
    function tab_langs()
    {
        return LangSet::get();
    }
}
if (!function_exists('menu_langs')) {
    function menu_langs()
    {
        return LangSet::whereIN('status', ['active', 'default'])->where('lang', '!=', app()->getLocale())->orderBy('sort')->get();
    }
}
if (!function_exists('menu_langs_admin')) {
    function menu_langs_admin()
    {
        return LangSet::whereIN('status', ['active', 'default'])->where('lang', '!=', session('admin-lang'))->orderBy('sort')->get();
    }
}
if (!function_exists('menu_langs_all')) {
    function menu_langs_all()
    {
        return LangSet::whereIN('status', ['active', 'default'])->orderBy('sort')->get();
    }
}
if (!function_exists('site_lang')) {
    function site_lang()
    {
        return LangSet::where('lang', app()->getLocale())->first();
    }
}
if (!function_exists('lang')) {
    function lang()
    {
        return app()->getLocale();
    }
}
if (!function_exists('store_lang')) {
    function store_lang($item, $request, $cols, $type, $end = null)
    {
        $langs = LangSet::whereIN('status', ['active', 'pending'])->get();
        if ($type == 'edit') {
            foreach ($item->langs as $l_del) {
                $l_del->delete();
            }
        }
        foreach ($langs as $lang) {
            foreach ($cols as $col) {
                if ($end == 'not_request') {

                    $crm_lang_en = CrmLang::where('value', $item->$col)->first();

                    if ($crm_lang_en) {
                        $crm_lang = CrmLang::where('parent_id', $crm_lang_en->id)->where('lang', $lang->lang)->first();

                        if ($crm_lang) {
                            $new_l = new Lang();
                            $new_l->col_name = $col;
                            $new_l->lang = $lang->lang;
                            $new_l->text = $crm_lang->value;
                            $item->langs()->save($new_l);
                        }
                    }
                } else {
                    $col_lang = $col . '_' . $lang->lang;
                    if (auth()->user()->hasRole('supplier')) {
                        if ($col == 'status') {
                            $new_l = new Lang();
                            $new_l->col_name = $col;
                            $new_l->lang = $lang->lang;
                            $new_l->text = 'active';
                            $item->langs()->save($new_l);
                        } elseif (!blank($request->$col_lang)) {
                            $new_l = new Lang();
                            $new_l->col_name = $col;
                            $new_l->lang = $lang->lang;
                            $new_l->text = $request->$col_lang;
                            $item->langs()->save($new_l);
                        } elseif (blank($request->$col_lang)) {
                            $new_l = new Lang();
                            $new_l->col_name = $col;
                            $new_l->lang = $lang->lang;
                            $new_l->text = translateTextSave($request->$col, $lang->lang);
                            $item->langs()->save($new_l);
                        }
                    } else {
                        if (!blank($request->$col_lang)) {
                            $new_l = new Lang();
                            $new_l->col_name = $col;
                            $new_l->lang = $lang->lang;
                            $new_l->text = $request->$col_lang;
                            $item->langs()->save($new_l);
                        }
                    }
                }
            }
        }
    }
}
if (!function_exists('store_lang_for_array_data')) {
    function store_lang_for_array_data($model, array $data, array $columns, string $mode = 'create')
    {
        $activeLangs = LangSet::whereIn('status', ['active', 'pending'])->get();

        if ($mode === 'edit') {
            $model->langs()->delete();
        }

        foreach ($activeLangs as $lang) {
            foreach ($columns as $column) {
                $langKey = $column.'_'.$lang->lang;

                if (array_key_exists($langKey, $data) && !blank($data[$langKey])) {
                    $model->langs()->create([
                        'col_name' => $column,
                        'lang' => $lang->lang,
                        'text' => $data[$langKey]
                    ]);
                }
                elseif (array_key_exists($column, $data) && blank($data[$langKey] ?? null)) {
                    $model->langs()->create([
                        'col_name' => $column,
                        'lang' => $lang->lang,
                        'text' => translateTextSave($data[$column], $lang->lang)
                    ]);
                }
            }
        }
    }
}
if (!function_exists('store_attributes_for_multi_lang')) {
    function store_attributes_for_multi_lang($model, array $data, string $mode = 'create')
    {
        $activeLangs = LangSet::whereIn('status', ['active', 'pending'])->get();

        if ($mode === 'edit') {
            $model->features()->delete();
            $model->langs()->where('langs_type', ProductFeature::class)->delete();
        }


        if (isset($data['attributes']) && is_array($data['attributes'])) {
            foreach ($data['attributes'] as $attribute) {
                if (isset($attribute['title'], $attribute['value'])) {
                    $feature = $model->features()->create([
                        'title' => $attribute['title'],
                        'value' => $attribute['value'],
                    ]);

                    foreach ($activeLangs as $lang) {
                        if ($lang->lang === 'en') {
                            continue;
                        }

                        $langKey = 'attributes_' . $lang->lang;
                        if (isset($data[$langKey]) && is_array($data[$langKey])) {
                            foreach ($data[$langKey] as $index => $attr) {
                                if ($index >= count($data['attributes'])) {
                                    break;
                                }

                                $titleKey = 'title_' . $lang->lang;
                                $valueKey = 'value_' . $lang->lang;

                                if (isset($attr[$titleKey], $attr[$valueKey])) {
                                    $model->langs()->create([
                                        'langs_type' => ProductFeature::class,
                                        'langs_id' => $feature->id,
                                        'col_name' => 'title',
                                        'lang' => $lang->lang,
                                        'text' => $attr[$titleKey],
                                    ]);

                                    $model->langs()->create([
                                        'langs_type' => ProductFeature::class,
                                        'langs_id' => $feature->id,
                                        'col_name' => 'value',
                                        'lang' => $lang->lang,
                                        'text' => $attr[$valueKey],
                                    ]);
                                } elseif (isset($attribute['title'], $attribute['value'])) {
                                    $model->langs()->create([
                                       purchase_feature::class,
                                        'langs_id' => $feature->id,
                                        'col_name' => 'title',
                                        'lang' => $lang->lang,
                                        'text' => translateTextSave($attribute['title'], $lang->lang),
                                    ]);

                                    $model->langs()->create([
                                        'langs_type' => ProductFeature::class,
                                        'langs_id' => $feature->id,
                                        'col_name' => 'value',
                                        'lang' => $lang->lang,
                                        'text' => translateTextSave($attribute['value'], $lang->lang),
                                    ]);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
if (!function_exists('store_lang2')) {
    function store_lang2($item, $request, $cols, $type, $end = null)
    {
        $langs = LangSet::all();
        if ($type == 'edit') {
            foreach ($item->langs as $l_del) {
                $l_del->delete();
            }
        }
        foreach ($langs as $lang) {
            foreach ($cols as $col) {
                if ($end == 'not_request') {

                    $crm_lang_en = CrmLang::where('value', $item->$col)->first();

                    if ($crm_lang_en) {
                        $crm_lang = CrmLang::where('parent_id', $crm_lang_en->id)->where('lang', $lang->lang)->first();

                        if ($crm_lang) {
                            $new_l = new Lang();
                            $new_l->col_name = $col;
                            $new_l->lang = $lang->lang;
                            $new_l->text = $crm_lang->value;
                            $item->langs()->save($new_l);
                        }
                    }
                } else {
                    $col_lang = $col . '_' . $lang->lang;
                    if (auth()->user()->hasRole('supplier')) {
                        if ($col == 'status') {
                            $new_l = new Lang();
                            $new_l->col_name = $col;
                            $new_l->lang = $lang->lang;
                            $new_l->text = 'active';
                            $item->langs()->save($new_l);
                        } elseif (!blank($request->$col_lang)) {
                            $new_l = new Lang();
                            $new_l->col_name = $col;
                            $new_l->lang = $lang->lang;
                            $new_l->text = $request->$col_lang;
                            $item->langs()->save($new_l);
                        } elseif (blank($request->$col_lang)) {
//                            dd($request->$col,translateText3($request->$col,$lang->lang),$lang->lang);
                            $new_l = new Lang();
                            $new_l->col_name = $col;
                            $new_l->lang = $lang->lang;
                            $new_l->text = translateTextSave($request->$col, $lang->lang);
                            $item->langs()->save($new_l);
                        }
                    } else {
                        if (!blank($request->$col_lang)) {
                            $new_l = new Lang();
                            $new_l->col_name = $col;
                            $new_l->lang = $lang->lang;
                            $new_l->text = $request->$col_lang;
                            $item->langs()->save($new_l);
                        }
                    }
                }
            }
        }
    }
}
if (!function_exists('read_lang')) {
    function read_lang($item, $col_name, $lang = null)
    {
        $lang = $lang == null ? lang() : $lang;
        $lang_def = LangSet::where('lang', $lang)->first();
        if ($lang_def->status == 'default') {
            $text = $item->$col_name;
        } else {
            $lang_item = $item->langs->where('lang', $lang_def->lang)->where('col_name', $col_name)->first();
            if ($lang_item)
                $text = $lang_item->text;
            else
                $text = null;
        }

        return $text;
    }
}
if (!function_exists('read_lang_word')) {
    function read_lang_word($slug, $lang = null)
    {
        $item = SiteWord::where('slug', $slug)->first();

        if (!$item) {
            return null;
        }
        $col_name = 'word';
        $lang = $lang == null ? app()->getLocale() : $lang;
        $lang_def = LangSet::where('lang', $lang)->first();

        if ($lang_def->lang == 'fa') {
            $text = $item->$col_name;
        } else {
            $text = null;
            if ($item->langs && count($item->langs)) {
                $lang_item = $item->langs->where('lang', $lang_def->lang)->where('col_name', $col_name)->first();

                if ($lang_item)
                    $text = $lang_item->text;
            }
        }
        return $text;
    }
}
if (!function_exists('status_check')) {
    function status_check($item, $lang = null)
    {
        $status = false;
        $lang = $lang ?? lang();
        $lang_def = LangSet::where('lang', $lang)->first();

        if ($lang_def->status == 'default')
            $status = $item->status == 'active' ? true : false;
        else {
            $lang_item = $item->langs->where('lang', $lang_def->lang)->where('col_name', 'status')->first();
            if ($lang_item)
                $status = $lang_item->text == 'active' ? true : false;
        }

        return $status;
    }
}
if (!function_exists('status_check_all')) {
    function status_check_all($items, $lang = null)
    {
        $lang = $lang ?? app()->getLocale();
        $items = $items->filter(function ($item) use ($lang) {
            if (status_check($item, $lang)) {
                return $item;
            }
        });

        return $items;
    }
}
if (!function_exists('num_to_en')) {
    function num_to_en($data)
    {
        if (is_array($data)) {
            return array_map('num_to_en', $data);
        }
        $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹', '٤', '٥', '٦'];
        $english = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '4', '5', '6'];
        $output = str_replace($persian, $english, $data);
        return $output;
    }
}
if (!function_exists('type_file')) {
    function type_file($item)
    {
        $type = explode('.', $item);
        $end = end($type);
        return $end;
    }
}
if (!function_exists('explode_last')) {
    function explode_last($item, $joda)
    {
        $type = explode($joda, $item);
        $end = end($type);
        return $end;
    }
}
if (!function_exists('phone_check')) {
    function phone_check($item)
    {
        $number = '';
        $number .= substr($item, 0, 3);
        $number .= '-';
        $number .= substr($item, 3);
        return $number;
    }
}
if (!function_exists('status')) {
    function status($item)
    {
        switch ($item) {
            case 'active':
            {
                return '<span class="badge badge-success">فعال</span>';
                break;
            }
            case 'pending':
            {
                return '<span class="badge badge-warning">درحال بررسی</span>';
                break;
            }
            case 'blocked':
            {
                return '<span class="badge badge-danger">مسدود</span>';
                break;
            }
            case 'cancel':
            {
                return '<span class="badge badge-danger">کنسل</span>';
                break;
            }
            case 'inactive':
            {
                return '<span class="badge badge-danger">غیرفعال</span>';
                break;
            }
        }
    }
}
if (!function_exists('file_store')) {
    function file_store($u_file, $u_path)
    {
        $file = $u_file;
        $originalName = $u_file->getClientOriginalName();
        $destinationPath = $u_path . my_jdate(date('Y/m/d'), 'Y-m-d') . '/' . time();
        $file->move($destinationPath, $originalName);
        return $destinationPath . '/' . $originalName;
    }
}
/*if (!function_exists('livewire_file_store')) {
    function livewire_file_store($file, $basePath)
    {
            $originalName = $file->getClientOriginalName();
            $safeName = time() . '_' . preg_replace('/[^a-zA-Z0-9_\-\.]/', '_', $originalName);

            $datePath = my_jdate(date('Y/m/d'), 'Y-m-d');
            $uniquePath = $datePath . '/' . time();
            $fullPath = rtrim($basePath, '/') . '/' . $uniquePath;

            if (!File::isDirectory($fullPath)) {
                File::makeDirectory($fullPath, 0755, true, true);
            }

            File::move($file->getRealPath(), $fullPath . '/' . $safeName);

            return $uniquePath . '/' . $safeName;
    }
}*/
if (!function_exists('delete_directory')) {
    function delete_directory($path)
    {
        $path_array = explode('/', $path);
        $file_name = '/' . end($path_array);
        $directory_name = str_replace($file_name, '', $path);
        File::deleteDirectory($directory_name);

        $pre_path_array = explode('/', $directory_name);
        $pre_file_name = '/' . end($pre_path_array);
        $pre_directory_name = str_replace($pre_file_name, '', $directory_name);
        $arr1 = scandir($pre_directory_name);
        unset($arr1[0], $arr1[1]);

        if (count($arr1) == 0)
            File::deleteDirectory($pre_directory_name);
    }
}

if (!function_exists('my_gdate')) {
    function my_gdate($data)
    {
        $data = str_replace('-', '/', $data);
        $data = explode('/', $data);
        if (count($data) > 2) {
            require_once('jdf.php');
            $date = jalali_to_gregorian($data[0], $data[1], $data[2], '/');
            return $date;
        }
        return false;
    }
}
if (!function_exists('my_jdate')) {
    function my_jdate($date, $type)
    {
        $timestamp = (strtotime($date));
        require_once('jdf.php');
        $jalali_date = jdate($type, $timestamp);
        return $jalali_date;
    }
}

if (!function_exists('array_pluck')) {
    function array_pluck($items, $value, $title, $defult = null)
    {
        $r = [];
        if ($defult != null) {
            $r = [$defult[0] => $defult[1]];
        }

        $r += Arr::pluck($items, $value, $title);
        return $r;

    }
}

if (!function_exists('array_pluck2')) {
    function array_pluck2($items, $value, $value2, $title, $defult = null)
    {
        $r = [];
        if ($defult != null) {
            $r = [$defult[0] => $defult[1]];
        }
        foreach ($items as $item) {
            $r += [$item->$title => $item->$value . ' ( +' . $item->$value2 . ' )'];
        }
        return $r;

    }
}

if (!function_exists('formatDateRange')) {
    function formatDateRange($startDate, $endDate)
    {
        $start = new DateTime($startDate);
        $end = new DateTime($endDate);

        $startMonth = $start->format('F');
        $startDay = $start->format('j');
        $startYear = $start->format('Y');

        $endMonth = $end->format('F');
        $endDay = $end->format('j');
        $endYear = $end->format('Y');

        if ($startYear !== $endYear) {
            return $startMonth . ' ' . $startDay . ', ' . $startYear . ' - ' .
                $endMonth . ' ' . $endDay . ', ' . $endYear;
        }

        if ($startMonth === $endMonth) {
            return $startMonth . ' ' . $startDay . '-' . $endDay . ', ' . $startYear;
        } else {
            return $startMonth . ' ' . $startDay . ' - ' . $endMonth . ' ' . $endDay . ', ' . $startYear;
        }
    }
}