<?php

namespace App\Http\Controllers\Admin\Blog;

use App\Http\Controllers\Controller;
use App\Http\Requests\Blog\BlogCategoryRequest;
use App\Models\BlogCategory;
use Illuminate\Http\Request;

class BlogCategoryController extends Controller
{

    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('دسته بندی مقالات',lang_admin());
                break;
            case 'create':
                return translateText('افزودن دسته',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش دسته',lang_admin());
                break;
            case 'url_back':
                return route('admin.blog-category.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:blog_category_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:blog_category_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:blog_category_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:blog_category_delete', ['only' => ['destroy']]);
        $this->middleware('permission:blog_category_sort', ['only' => ['sort']]);
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $items = BlogCategory::orderBy('sort')->get();
        return view('admin.blog.category.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.blog.category.create', ['title' => $this->controller_title('create')]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(BlogCategoryRequest $request)
    {
        try {
            $item = BlogCategory::create([
                'title' => $request->title,
                'slug' => $request->slug,
                'status' => $request->status,
            ]);

            store_lang($item, $request, ['title', 'status', 'slug',], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(BlogCategory $blogCategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(BlogCategory $blogCategory)
    {
        return view('admin.blog.category.edit', compact('blogCategory'), ['title' => $this->controller_title('edit')]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(BlogCategoryRequest $request, BlogCategory $blogCategory)
    {
        try {
            $blogCategory->update([
                'title' => $request->title,
                'slug' => $request->slug,
                'status' => $request->status,
            ]);

            store_lang($blogCategory, $request, ['title', 'status', 'slug'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(BlogCategory $blogCategory)
    {
        try {
            $blogCategory->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function sort(BlogCategory $blogCategory, Request $request)
    {
        $this->validate($request, [
            'sort' => 'required|numeric|min:1'
        ]);
        try {
            $blogCategory->sort = $request->sort;
            $blogCategory->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت سورت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای سورت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }


}
