<?php

namespace App\Http\Controllers\Admin\Blog;

use App\Http\Controllers\Controller;
use App\Http\Requests\Blog\TagRequest;
use App\Models\Tag;
use Illuminate\Http\Request;

class TagController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('برچسب ها',lang_admin());
                break;
            case 'create':
                return translateText('افزودن برچسب',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش برچسب',lang_admin());
                break;
            case 'url_back':
                return route('admin.tags.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:tag_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:tag_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:tag_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:tag_delete', ['only' => ['destroy']]);
        $this->middleware('permission:tag_sort', ['only' => ['id']]);
    }

    public function index()
    {
        $items = Tag::orderBy('id')->get();
        return view('admin.blog.tags.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        return view('admin.blog.tags.create', compact('url_back'), ['title' => $this->controller_title('create')]);
    }

    public function store(TagRequest $request)
    {
        try {
            $item = Tag::create([
                'title' => $request->title,
                'status' => $request->status,
                'slug' => $request->slug,
                'text' => $request->text,
            ]);

            store_lang($item, $request, ['title', 'status', 'text'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = Tag::where('id', $id)->firstOrFail();
        return view('admin.blog.tags.edit', compact('url_back', 'item'), ['title' => $this->controller_title('edit')]);
    }

    public function update(TagRequest $request, $id)
    {
        $item = Tag::where('id', $id)->firstOrFail();
        try {
            Tag::where('id', $id)->update([
                'title' => $request->title,
                'status' => $request->status,
                'slug' => $request->slug,
                'text' => $request->text,

            ]);


            store_lang($item, $request, ['title', 'status', 'text'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function destroy($id)
    {
        $item = Tag::where('id', $id)->firstOrFail();
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function sort($id, Request $request)
    {
        $item = Tag::where('id', $id)->firstOrFail();
        try {
            $item->sort = $request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت سورت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای سورت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
