<?php

namespace App\Http\Controllers\Admin\Company;

use App\Http\Controllers\Controller;
use App\Http\Requests\Company\CompanyFormRequest;
use App\Models\Photo;
use App\Imports\CatImport;
use App\Models\CompanyForm;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Maatwebsite\Excel\Facades\Excel;

class CompanyFormController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('مدیریت فرم شرکت',lang_admin());
                break;
            case 'create':
                return translateText('افزودن',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش',lang_admin());
                break;
            case 'url_back':
                return route('admin.company-form.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:company_form_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:company_form_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:company_form_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:company_form_delete', ['only' => ['destroy']]);
        $this->middleware('permission:company_form_sort', ['only' => ['sort']]);
    }

    public function index()
    {
        $items = CompanyForm::orderBy('type')
            ->orderBy('sort')
            ->get();

        return view('admin.company.form.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        return view('admin.company.form.create', compact('url_back'), ['title' => $this->controller_title('create')]);
    }

    public function store(CompanyFormRequest $request)
    {
        try {
            $item = CompanyForm::create([
                'title' => $request->title,
                'status' => $request->status,
                'type' => $request->type
            ]);
            store_lang($item, $request, ['title', 'status'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = CompanyForm::findOrFail($id);

        return view('admin.company.form.edit', compact('url_back', 'item'), ['title' => $this->controller_title('edit')]);
    }

    public function update(CompanyFormRequest $request, $id)
    {
        $item = CompanyForm::findOrFail($id);
        try {
            CompanyForm::where('id', $id)->update([
                'title' => $request->title,
                'status' => $request->status,
                'type' => $request->type
            ]);

            store_lang($item, $request, ['title', 'status'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function destroy($id)
    {
        $item = CompanyForm::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function sort($id, Request $request)
    {
        $item = CompanyForm::findOrFail($id);
        try {
            $item->sort = $request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت سورت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای سورت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
