<?php
namespace App\Http\Controllers\Admin\Company;

use App\Http\Controllers\Controller;
use App\Http\Requests\Company\FactoryInformationRequest;
use App\Models\FactoryInformation;
use App\Models\Photo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class FactoryInformationController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('اطلاعات کارخانه', lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش اطلاعات کارخانه', lang_admin());
                break;
            case 'url_back':
                return route('admin.factory-information.edit',auth()->id());
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:company_edit', ['only' => ['edit', 'update']]);
    }
    public function edit($id)
    {
        $item = FactoryInformation::firstOrCreate(['user_id' => $id], ['user_id' => $id]);

        return view('admin.company.factory_information.edit', compact('item'), ['title' => $this->controller_title('edit')]);
    }

    public function update(FactoryInformationRequest $request, $id)
    {
        $item = FactoryInformation::findOrFail($id);

        try {
            $item->update([
                'factory_location' => $request->factory_location,
                'factory_total_area' => $request->factory_total_area,
                'no_production_staff' => $request->no_production_staff,
                'no_qc_staff' => $request->no_qc_staff,
                'no_rd_staff' => $request->no_rd_staff,
                'no_production_lines' => $request->no_production_lines,
                'annual_output' => $request->annual_output,
                'average_lead_time' => $request->average_lead_time,
            ]);
            if ($request->hasFile('gallery')) {
                foreach ($request->gallery as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'gallery';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/company/factory/gallery' . '/');
                    $item->gallery()->save($gallery);
                }
            }
            if ($request->hasFile('video')) {
                if ($item->video) {
                    if (is_file($item->video->path)) {
                        File::delete($item->video->path);
                        delete_directory($item->video->path);
                    }
                    $item->video->delete();
                }
                $photo = new Photo();
                $photo->type = 'video';
                $photo->path = file_store($request->video, 'assets/admin/uploads/company/factory/video' . '/');
                $item->video()->save($photo);
            }

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }
}