<?php
namespace App\Http\Controllers\Admin\Company;

use App\Http\Controllers\Controller;
use App\Models\TradingInformation;
use App\Models\CompanyForm;
use App\Models\Country;
use App\Models\RfqForm;
use App\Http\Requests\Company\TradingInformationRequest;
use Illuminate\Http\Request;

class TradingInformationController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('اطلاعات تجارت', lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش اطلاعات تجارت', lang_admin());
                break;
            case 'url_back':
                return route('admin.trading-information.edit', auth()->id());
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:company_edit', ['only' => ['edit', 'update']]);
    }

    public function edit($id)
    {
        $item = TradingInformation::firstOrCreate(
            ['user_id' => $id],
            ['user_id' => $id]
        );

        $annual_turnovers = CompanyForm::where('type', 'annual_turnover')
            ->pluck('title', 'title')
            ->all();

        $export_revenues = CompanyForm::where('type', 'export_revenue')
            ->pluck('title', 'title')
            ->all();

        $total_capitalizations = CompanyForm::where('type', 'total_capitalization')
            ->pluck('title', 'title')
            ->all();

        $trade_terms = RfqForm::where('type', 'trade_terms')
            ->pluck('title1', 'title1')
            ->all();

        $countries = Country::orderBy('name')->pluck('name', 'id')->all();

        return view('admin.company.trading_information.edit', compact('item', 'annual_turnovers', 'export_revenues', 'total_capitalizations', 'trade_terms', 'countries'), ['title' => $this->controller_title('edit')]);
    }

    public function update(TradingInformationRequest $request, $id)
    {
        $item = TradingInformation::findOrFail($id);

        try {
            $item->update([
                'import_export_license' => $request->import_export_license,
                'annual_turnover' => $request->annual_turnover,
                'export_revenue' => $request->export_revenue,
                'export_percentage' => $request->export_percentage,
                'total_capitalization' => $request->total_capitalization,
                'nearest_port' => $request->nearest_port,
                'terms_of_trades' => json_encode($request->terms_of_trades),
            ]);

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد', lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید', lang_admin()));
        }
    }
}