<?php

namespace App\Http\Controllers\Admin\Form;

use App\Models\ContactForm;
use App\Models\SellYourProduct;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Carbon\Carbon;

class AllFormController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'contact':
                return translateText('فرم تماس با ما', lang_admin());
                break;
            case 'sell_your_product':
                return translateText('فرم SellYourProduct', lang_admin());
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:form_contact_list', ['only' => ['contact']]);
        $this->middleware('permission:form_contact_sell_your_product', ['only' => ['sell_your_product', 'sell_your_product_status']]);
    }

    public function contact()
    {
        $items = ContactForm::orderBYDesc('id')->get();
        return view('admin.form.contact', compact('items'), ['title' => $this->controller_title('contact')]);
    }

    public function sell_your_product()
    {
        $items = SellYourProduct::orderBYDesc('id')->get();
        return view('admin.form.sell_your_product', compact('items'), ['title' => $this->controller_title('sell_your_product')]);
    }

    public function sell_your_product_status($id)
    {
        $item = SellYourProduct::where('status', 'pending')->findOrFail($id);
        try {
            $item->status = 'active';
            $item->date_status = Carbon::now();
            $item->update();

            return redirect()->back()->with('flash_message', translateText('با موفقیت تغییر وضعیت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای تغییر وضعیت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

}
