<?php

namespace App\Http\Controllers\Admin\Land;

use App\Models\Landing;
use App\Models\LandingDetail;
use App\Models\Photo;
use App\Models\Faq;
use App\Models\Blog;
use App\Http\Requests\Land\LandingRequest;
use App\Http\Controllers\Controller;
use Cassandra\Blob;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

use Spatie\Permission\Models\Permission;

class LandingController extends Controller
{
    public function controller_title($type, $l_id = null)
    {
        $l = null;
        if (!blank($l_id))
            $l = Landing::find($l_id);

        if ($l)
            $l = $l->title;

        switch ($type) {
            case 'index':
                return translateText('صفحه فرود',lang_admin()).' ' . $l;
                break;
            case 'create':
                return translateText('افزودن',lang_admin()).' ' . $l;
                break;
            case 'edit':
                return translateText('ویرایش',lang_admin()).' ' . $l;
                break;
            case 'url_back':
                return route('admin.land.index', !blank($l_id) ? ['l_id' => $l_id] : '');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:landing_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:landing_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:landing_delete', ['only' => ['destroy']]);
        $this->middleware('permission:landing_edit', ['only' => ['edit', 'update']]);
    }

    public function index(Request $request)
    {
        if (isset($request->l_id)) {
            $l_id = $request->l_id;
            $l=landing::whereNull('link')->findOrFail($l_id);
            $items = LandingDetail::where('l_id', $request->l_id)->orderBy('sort')->get();
            $url_back = $this->controller_title('url_back');
        } else {
            $l_id = null;
            $items = landing::orderBy('id')->get();
            $url_back = null;
        }
        return view('admin.land.index', compact('items', 'url_back', 'l_id'), ['title' => $this->controller_title('index', $l_id)]);
    }

    public function create(Request $request)
    {
        if (isset($request->l_id)) {
            Landing::findOrFail($request->l_id);
            $l_id = $request->l_id;
            $url_back = $this->controller_title('url_back', $l_id);
        } else {
            $l_id = null;
            $url_back = $this->controller_title('url_back');
        }
        return view('admin.land.create', compact('url_back', 'l_id'), ['title' => $this->controller_title('create', $l_id)]);
    }

    public function store(LandingRequest $request)
    {
        try {
            if (isset($request->l_id)) {
                Landing::findOrFail($request->l_id);
                $item = LandingDetail::create([
                    'l_id' => $request->l_id,
                    'title' => $request->title,
                    'status' => $request->status,
                    'text' => $request->text,
                    'v_h' => $request->v_h,
                    'width' => $request->width,
                    'sort' => $request->sort,
                ]);
                //create pic
                if ($request->hasFile('photo')) {
                    $photo = new Photo();
                    $photo->type = 'photo';
                    $photo->path = file_store($request->photo, 'assets/uploads/landing/detail/' . my_jdate(date('Y/m/d'), 'Y-m-d') . '/photos/', 'photo-');
                    $item->photo()->save($photo);
                }

                store_lang($item, $request, ['status', 'text'], 'create');

                return redirect($this->controller_title('url_back', $request->l_id))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
            } else {
                $item = Landing::create([
                    'title' => $request->title,
                    'title_footer' => $request->title_footer,
                    'status' => $request->status,
                    'footer' => $request->footer,
                    'slug' =>$request->slug,
                ]);
                store_lang($item, $request, ['title','title_footer', 'status'], 'create');

                return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
            }


        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function edit($id, Request $request)
    {
        if (isset($request->l_id)) {
            $item = landingDetail::findOrFail($id);
            Landing::findOrFail($request->l_id);
            $l_id = $request->l_id;
            $url_back = $this->controller_title('url_back', $l_id);
        } else {
            $item = landing::findOrFail($id);
            $l_id = null;
            $url_back = $this->controller_title('url_back');
        }
        return view('admin.land.edit', compact('url_back', 'item', 'l_id'), ['title' => $this->controller_title('edit', $l_id)]);
    }

    public function update($id, LandingRequest $request)
    {
        try {
            if (isset($request->l_id)) {
                Landing::findOrFail($request->l_id);
                $item = landingDetail::findOrFail($id);
                landingDetail::where('id', $id)->update([
                    'l_id' => $request->l_id,
                    'title' => $request->title,
                    'status' => $request->status,
                    'text' => $request->text,
                    'v_h' => $request->v_h,
                    'width' => $request->width,
                    'sort' => $request->sort,
                ]);
                //create pic
                if ($request->hasFile('photo')) {
                    if ($item->photo) {
                        if (is_file($item->photo->path)) {
                            File::delete($item->photo->path);
                        }
                        $item->photo->delete();
                    }
                    $photo = new Photo();
                    $photo->type = 'photo';
                    $photo->path = file_store($request->photo, 'assets/uploads/landing/detail/' . my_jdate(date('Y/m/d'), 'Y-m-d') . '/photos/', 'photo-');
                    $item->photo()->save($photo);
                }

                store_lang($item, $request, ['status', 'text'], 'edit');

                return redirect($this->controller_title('url_back', $request->l_id))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
            } else {
                $item = landing::findOrFail($id);
                Landing::where('id', $id)->update([
                    'title' => $request->title,
                    'title_footer' => $request->title_footer,
                    'status' => $request->status,
                    'footer' => $request->footer,
                    'slug' => $request->slug,
                ]);
                store_lang($item, $request, ['title', 'title_footer', 'status'], 'edit');

                return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
            }
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        }
    }

    public function destroy($id, Request $request)
    {

        try {
            if (isset($request->l_id)) {
                Landing::findOrFail($request->l_id);
                $item = LandingDetail::findOrFail($id);
            } else {
                $item = Landing::findOrFail($id);
                if (count($item->details)) {
                    foreach ($item->details as $d) {
                        $d->delete();
                    }
                }
            }
            $item->delete();
            return redirect()->back()->with('flash_message',translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
