<?php

namespace App\Http\Controllers\Admin\Other;

use App\Http\Controllers\Controller;
use App\Http\Requests\Other\ExhibitionRequest;
use App\Models\Photo;
use App\Imports\CatImport;
use App\Models\Exhibition;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Maatwebsite\Excel\Facades\Excel;

class ExhibitionController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('دسته نمایشگاه',lang_admin());
                break;
            case 'create':
                return translateText('افزودن نمایشگاه',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش نمایشگاه',lang_admin());
                break;
            case 'url_back':
                return route('admin.other-exhibition.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:exhibition_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:exhibition_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:exhibition_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:exhibition_delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $items = Exhibition::orderBy('sort')->get();
        return view('admin.other.exhibition.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        return view('admin.other.exhibition.create', compact('url_back'), ['title' => $this->controller_title('create')]);
    }

    public function store(ExhibitionRequest $request)
    {
        try {
            $item = Exhibition::create([
                'title' => $request->title,
                'industry' => $request->industry,
                'start_date' => $request->start_date,
                'end_date' => $request->end_date,
                'text' => $request->text,
                'status' => $request->status,
                'type' => $request->type,
                'link' => $request->link,
                'slug' => $request->slug
            ]);

            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/exhibition/photo' . '/');
                $item->photo()->save($photo);
            }

            store_lang($item, $request, ['title', 'industry','text', 'status'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            dd($e->getMessage());
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = Exhibition::findOrFail($id);
        return view('admin.other.exhibition.edit', compact('url_back', 'item'), ['title' => $this->controller_title('edit')]);
    }

    public function update(ExhibitionRequest $request, $id)
    {
        $item = Exhibition::findOrFail($id);
        try {
            Exhibition::where('id', $id)->update([
                'title' => $request->title,
                'industry' => $request->industry,
                'start_date' => $request->start_date,
                'end_date' => $request->end_date,
                'text' => $request->text,
                'status' => $request->status,
                'type' => $request->type,
                'link' => $request->link,
                'slug' => $request->slug
            ]);
            //edit category
            if ($request->hasFile('photo')) {
                if ($item->photo) {
                    if (is_file($item->photo->path)) {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/exhibition/photo' . '/');
                $item->photo()->save($photo);
            }

            store_lang($item, $request, ['title', 'industry','text', 'status'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function destroy($id)
    {
        $item = Exhibition::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function sort($id, Request $request)
    {
        $item = Exhibition::findOrFail($id);
        try {
            $item->sort = $request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت سورت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای سورت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
