<?php

namespace App\Http\Controllers\Admin\Other;

use App\Models\Faq;
use App\Http\Requests\Other\FaqRequest;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use otherbon\otherbon;

class FaqController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return translateText('سوالات متداول',lang_admin());
                break;
            case 'create':
                return translateText('افزودن سوالات متداول',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش سوالات متداول',lang_admin());
                break;
            case 'url_back':
                return route('admin.faq.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:faq_list', ['only' => ['index','show']]);
        $this->middleware('permission:faq_create', ['only' => ['create','store']]);
        $this->middleware('permission:faq_edit', ['only' => ['edit','update']]);
        $this->middleware('permission:faq_delete', ['only' => ['destroy']]);
        $this->middleware('permission:faq_status', ['only' => ['status']]);
        $this->middleware('permission:faq_sort', ['only' => ['sort']]);
    }

    public function index()
    {
        $items=Faq::orderBy('sort')->get();
        return view('admin.other.faq.index', compact('items'), ['title' => $this->controller_title('index')]);
    }
    public function show($id)
    {

    }
    public function create()
    {
        $url_back=$this->controller_title('url_back');
        return view('admin.other.faq.create',compact('url_back'), ['title' => $this->controller_title('create')]);
    }
    public function store(FaqRequest $request)
    {
        try {
            $item = Faq::create([
                'question' => $request->question,
                'answer' => $request->answer,
                'status' => $request->status,
            ]);

            store_lang($item,$request,['question','answer','status'],'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            dd($e);
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function edit($id)
    {
        $url_back=$this->controller_title('url_back');
        $item=Faq::findOrFail($id);
        return view('admin.other.faq.edit',compact('url_back','item'), ['title' => $this->controller_title('edit')]);
    }
    public function update(FaqRequest $request,$id)
    {
        $item=Faq::findOrFail($id);
        try {
            Faq::where('id',$id)->update([
                'question' => $request->question,
                'answer' => $request->answer,
                'status' => $request->status,
            ]);
            store_lang($item,$request,['question','answer','status'],'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function destroy($id)
    {
        $item=Faq::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function sort($id,Request $request)
    {
        $item=Faq::findOrFail($id);
        try {
            $item->sort=$request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت سورت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای سورت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

}
