<?php

namespace App\Http\Controllers\Admin\Other;

use App\Http\Controllers\Controller;
use App\Http\Requests\Other\IndustryRequest;
use App\Models\Industry;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class IndustryController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'صنعت و صنعت فرعی ';
                break;
            case 'create':
                return 'افزودن صنعت و صنعت فرعی';
                break;
            case 'edit':
                return 'ویرایش صنعت و صنعت فرعی';
                break;
            case 'url_back':
                return route('admin.industry.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:industry_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:industry_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:industry_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:industry_delete', ['only' => ['destroy']]);
        $this->middleware('permission:industry_sort', ['only' => ['sort']]);
    }

    public function index()
    {
        $items = Industry::where('industry_id', null)->orderBy('created_at')->get();
        return view('admin.other.industry.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        $industry = Industry::where('industry_id', null)->orderBy('created_at')->get();
        return view('admin.other.industry.create', compact('url_back', 'industry'), ['title' => $this->controller_title('create')]);
    }

    public function store(IndustryRequest $request)
    {
        try {
            $item = Industry::create([
                'industry_id' => $request->industry_id != 'father' ? $request->industry_id : null,
                'title' => $request->title,
                'status' => $request->status,
                'slug' => $request->slug
            ]);

            store_lang($item, $request, ['title', 'status'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = Industry::findOrFail($id);
        $industry = Industry::where('industry_id', null)->where('id', '!=', $id)->orderBy('created_at')->get();
        return view('admin.other.industry.edit', compact('url_back', 'item', 'industry'), ['title' => $this->controller_title('edit')]);
    }

    public function update(IndustryRequest $request, $id)
    {
        $item = Industry::findOrFail($id);
        try {
            Industry::where('id', $id)->update([
                'industry_id' => $request->industry_id != 'father' ? $request->industry_id : null,
                'title' => $request->title,
                'status' => $request->status,
                'slug' => $request->slug
            ]);

            store_lang($item, $request, ['title', 'status'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function destroy($id)
    {
        $item = Industry::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }


}
