<?php

namespace App\Http\Controllers\Admin\Other;

use App\Http\Controllers\Controller;
use App\Http\Requests\Other\LearningRequest;
use App\Models\Photo;
use App\Imports\CatImport;
use App\Models\Learning;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Maatwebsite\Excel\Facades\Excel;

class LearningController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('دسته مرکز یادگیری',lang_admin());
                break;
            case 'create':
                return translateText('افزودن مرکز یادگیری',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش مرکز یادگیری',lang_admin());
                break;
            case 'url_back':
                return route('admin.learning.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:learning_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:learning_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:learning_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:learning_delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $items = Learning::orderBy('created_at')->get();
        return view('admin.other.learning.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        return view('admin.other.learning.create', compact('url_back'), ['title' => $this->controller_title('create')]);
    }

    public function store(LearningRequest $request)
    {
        try {
            $item = Learning::create([
                'text' => $request->text,
                'status' => $request->status,
                'link' => $request->link,
                'slug' => $request->slug
            ]);

            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/learning/photo' . '/');
                $item->photo()->save($photo);
            }
            if ($request->hasFile('video')) {
                $photo = new Photo();
                $photo->type = 'video';
                $photo->path = file_store($request->video, 'assets/admin/uploads/learning/video' . '/');
                $item->video()->save($photo);
            }

            store_lang($item, $request, ['text', 'status'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = Learning::findOrFail($id);
        return view('admin.other.learning.edit', compact('url_back', 'item'), ['title' => $this->controller_title('edit')]);
    }

    public function update(LearningRequest $request, $id)
    {
        $item = Learning::findOrFail($id);
        try {
            Learning::where('id', $id)->update([
                'text' => $request->text,
                'status' => $request->status,
                'link' => $request->link,
                'slug' => $request->slug
            ]);
            //edit category
            if ($request->hasFile('photo')) {
                if ($item->photo) {
                    if (is_file($item->photo->path)) {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/learning/photo' . '/');
                $item->photo()->save($photo);
            }

            if ($request->hasFile('video')) {
                if ($item->video) {
                    if (is_file($item->video->path)) {
                        File::delete($item->video->path);
                        delete_directory($item->video->path);
                    }
                    $item->video->delete();
                }
                $photo = new Photo();
                $photo->type = 'video';
                $photo->path = file_store($request->video, 'assets/admin/uploads/learning/video' . '/');
                $item->video()->save($photo);
            }

            store_lang($item, $request, ['text', 'status'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function destroy($id)
    {
        $item = Learning::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
