<?php

namespace App\Http\Controllers\Admin\Other;

use App\Models\Transport;
use App\Models\Setting;
use App\Models\Photo;
use App\Http\Requests\Other\TransportRequest;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class TransportController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return translateText('Import & Export Services',lang_admin());
                break;
            case 'create':
                return translateText('افزودن Import & Export Services',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش Import & Export Services',lang_admin());
                break;
            case 'url_back':
                return route('admin.transport.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:transport_list', ['only' => ['index','show']]);
        $this->middleware('permission:transport_create', ['only' => ['create','store']]);
        $this->middleware('permission:transport_edit', ['only' => ['edit','update','top_page']]);
        $this->middleware('permission:transport_delete', ['only' => ['destroy']]);
        $this->middleware('permission:transport_sort', ['only' => ['sort']]);
    }

    public function index()
    {
        $items=Transport::orderBy('sort')->get();
        $setting=Setting::first();
        return view('admin.other.transport.index', compact('items','setting'), ['title' => $this->controller_title('index')]);
    }
    public function show($id)
    {

    }
    public function create()
    {
        $url_back=$this->controller_title('url_back');
        return view('admin.other.transport.create',compact('url_back'), ['title' => $this->controller_title('create')]);
    }
    public function store(TransportRequest $request)
    {
        try {
            $item = Transport::create([
                'title' => $request->title,
                'about' => $request->about,
                'service' => $request->service,
                'latitude' => $request->latitude,
                'longitude' => $request->longitude,
                'status' => $request->status,
                'type' => $request->type,
            ]);
            //create Transport
            if ($request->hasFile('photos')) {
                foreach ($request->photos as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'photos';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/other/transport/photos', '/');
                    $item->photos()->save($gallery);
                }
            }
            if ($request->hasFile('video')) {
                    $gallery = new Photo();
                    $gallery->type = 'video';
                    $gallery->path = file_store($request->video, 'assets/admin/uploads/other/transport/video', '/');
                    $item->video()->save($gallery);
            }

            store_lang($item,$request,['title','about','service','status'],'create');
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function edit($id)
    {
        $url_back=$this->controller_title('url_back');
        $item=Transport::findOrFail($id);
        return view('admin.other.transport.edit',compact('url_back','item'), ['title' => $this->controller_title('edit')]);
    }
    public function update(TransportRequest $request,$id)
    {
        $item=Transport::findOrFail($id);
        try {
            Transport::where('id',$id)->update([
                'title' => $request->title,
                'about' => $request->about,
                'service' => $request->service,
                'latitude' => $request->latitude,
                'longitude' => $request->longitude,
                'status' => $request->status,
                'type' => $request->type,
            ]);
            //edit Transport
            if ($request->hasFile('photos')) {
                foreach ($request->photos as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'photos';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/other/transport/photos', '/');
                    $item->photos()->save($gallery);
                }
            }
            if ($request->hasFile('video')) {
                if($item->video)
                {
                    if(is_file($item->video->path))
                    {
                        File::delete($item->video->path);
                        delete_directory($item->video->path);
                    }
                    $item->video->delete();
                }
                $gallery = new Photo();
                $gallery->type = 'video';
                $gallery->path = file_store($request->video, 'assets/admin/uploads/other/transport/video', '/');
                $item->video()->save($gallery);
            }

            store_lang($item,$request,['title','about','service','status'],'edit');
            return redirect($this->controller_title('url_back'))->with('flash_message',translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function destroy($id)
    {
        $item=Transport::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function sort(Request $request,$id)
    {
        $item=Transport::findOrFail($id);
        try {
            $item->sort=$request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت سورت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای سورت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function top_page(Request $request)
    {
        $item=Setting::firstOrFail();
        try {
            $item->transport_title=$request->transport_title;
            $item->transport_text=$request->transport_text;
            $item->update();

            if ($request->hasFile('transport_photo')) {
                if($item->transport_photo)
                {
                    if(is_file($item->transport_photo->path))
                    {
                        File::delete($item->transport_photo->path);
                        delete_directory($item->transport_photo->path);
                    }
                    $item->transport_photo->delete();
                }
                $gallery = new Photo();
                $gallery->type = 'transport_photo';
                $gallery->path = file_store($request->transport_photo, 'assets/admin/uploads/other/transport/transport_photo', '/');
                $item->transport_photo()->save($gallery);
            }
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

}
