<?php

namespace App\Http\Controllers\Admin\Product;

use App\Http\Controllers\Controller;
use App\Http\Requests\Product\Supplier\CategoryRequest;
use App\Models\ProductCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class CategorySupplierController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('دسته بندی محصولات',lang_admin());
                break;
            case 'create':
                return translateText('افزودن دسته',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش دسته',lang_admin());
                break;
            case 'url_back':
                return route('admin.product-category-supplier.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:product_category_supplier_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:product_category_supplier_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:product_category_supplier_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:product_category_supplier_delete', ['only' => ['destroy']]);
        $this->middleware('permission:product_category_supplier_sort', ['only' => ['sort']]);
    }

    public function index()
    {
        $items = ProductCategory::where('user_id', auth()->id())->whereHas('parent_null')->orderBy('sort')->get();
        return view('admin.product.category.supplier.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        $cats = ProductCategory::where('parent_id', null)->orderBy('sort')->get();
        $cats2 = ProductCategory::where('parent_id','!=', null)->where('user_id',1)->orderBy('sort')->get();
        $cats3 = ProductCategory::where('user_id', auth()->id())->whereHas('parent_null')->orderBy('sort')->get();
        return view('admin.product.category.supplier.create', compact('url_back', 'cats','cats2','cats3'), ['title' => $this->controller_title('create')]);
    }

    public function store(CategoryRequest $request)
    {
        try {
            $item = ProductCategory::create([
                'user_id' => auth()->id(),
                'parent_id' => $request->parent_id == 'father' ? $request->parent_id2 : $request->parent_id,
                'title' => $request->title,
                'slug' => generateSlug($request->title)
            ]);
            $item->slug.=$item->id;
            $item->update();
            
            store_lang($item, $request, ['title'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = ProductCategory::where('user_id',auth()->id())->findOrFail($id);
        $cats = ProductCategory::where('parent_id', null)->orderBy('sort')->get();
        $cats2 = ProductCategory::where('parent_id','!=', null)->where('user_id',1)->orderBy('sort')->get();
        $cats3 = ProductCategory::where('user_id', auth()->id())->whereHas('parent_null')->orderBy('sort')->get();
        return view('admin.product.category.supplier.edit', compact('url_back', 'item', 'cats','cats2','cats3'), ['title' => $this->controller_title('edit')]);
    }

    public function update(CategoryRequest $request, $id)
    {
        $item = ProductCategory::where('user_id',auth()->id())->findOrFail($id);
        try {
            ProductCategory::where('id', $id)->update([
                'parent_id' => $request->parent_id == 'father' ? $request->parent_id2 : $request->parent_id,
                'title' => $request->title,
            ]);
            store_lang($item, $request, ['title'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function destroy($id)
    {
        $item = ProductCategory::where('user_id',auth()->id())->findOrFail($id);
        try {
            if(count($item->childs))
            {
                return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، والد دسته های دیگر است',lang_admin()));
            }
            if(count($item->products))
            {
                return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، به محصولات وصل است',lang_admin()));
            }
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function sort($id, Request $request)
    {
        $item = ProductCategory::where('user_id',auth()->id())->findOrFail($id);
        try {
            $item->sort = $request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت سورت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای سورت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

}
