<?php

namespace App\Http\Controllers\Admin\Rfq;

use App\Http\Controllers\Controller;
use App\Http\Requests\Rfq\RfqFormRequest;
use App\Models\Photo;
use App\Imports\CatImport;
use App\Models\RfqForm;
use App\Models\Rfq;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Maatwebsite\Excel\Facades\Excel;

class RfqFormController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('مدیریت فرم rfq',lang_admin());
                break;
            case 'index2':
                return translateText(' فرم های fq ارسال شده',lang_admin());
                break;
            case 'create':
                return translateText('افزودن',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش',lang_admin());
                break;
            case 'url_back':
                return route('admin.rfq-form.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:rfq_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:rfq_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:rfq_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:rfq_delete', ['only' => ['destroy']]);
        $this->middleware('permission:rfq_sort', ['only' => ['sort']]);
    }

    public function index()
    {
        $items = RfqForm::orderBy('type')
            ->orderBy('sort')
            ->get();

        return view('admin.rfq.form.index', compact('items'), ['title' => $this->controller_title('index')]);
    }
    public function index2()
    {
        $items = Rfq::with('user')
            ->orderBy('id', 'desc')
            ->get();

        return view('admin.rfq.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {
        $item = Rfq::with('user')->find($id);
        $item->seen = 'yes';
        $item->save();
        return view('admin.rfq.show', compact('item'), ['title' => $this->controller_title('index')]);
    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        return view('admin.rfq.form.create', compact('url_back'), ['title' => $this->controller_title('create')]);
    }

    public function store(RfqFormRequest $request)
    {
        try {
            $item = RfqForm::create([
                'title1' => $request->title1,
                'title2' => $request->title2,
                'title3' => $request->title3,
                'title4' => $request->title4,
                'status' => $request->status,
                'type' => $request->type
            ]);
            store_lang($item, $request, ['title1','title2','title3','title4', 'status'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = RfqForm::findOrFail($id);

        return view('admin.rfq.form.edit', compact('url_back', 'item'), ['title' => $this->controller_title('edit')]);
    }

    public function update(RfqFormRequest $request, $id)
    {
        $item = RfqForm::findOrFail($id);
        try {
            RfqForm::where('id', $id)->update([
                'title1' => $request->title1,
                'title2' => $request->title2,
                'title3' => $request->title3,
                'title4' => $request->title4,
                'status' => $request->status,
                'type' => $request->type
            ]);

            store_lang($item, $request, ['title1','title2','title3','title4', 'status'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function destroy($id)
    {
        $item = RfqForm::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function sort($id, Request $request)
    {
        $item = RfqForm::findOrFail($id);
        try {
            $item->sort = $request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت سورت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای سورت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
