<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Models\About;
use App\Models\AboutOption;
use App\Http\Requests\Setting\AboutRequest;
use App\Http\Requests\Setting\AboutOptionRequest;
use App\Http\Controllers\Controller;
use App\Models\Photo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

use Spatie\Permission\Models\Permission;
class AboutController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return translateText('درباره ما',lang_admin());
                break;
            case 'create':
                return translateText('افزودن درباره ما',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش درباره ما',lang_admin());
                break;
            case 'url_back':
                return route('admin.about.index');
                break;
            case 'option_index':
                return translateText('اطلاعات درباره ما',lang_admin());
                break;
            case 'option_create':
                return translateText('افزودن اطلاعات درباره ما',lang_admin());
                break;
            case 'option_edit':
                return translateText('ویرایش اطلاعات درباره ما',lang_admin());
                break;
            case 'option_url_back':
                return route('admin.about.option.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:about_list', ['only' => ['index','show']]);
        $this->middleware('permission:about_edit', ['only' => ['edit','update']]);

        $this->middleware('permission:about_option_list', ['only' => ['option_index']]);
        $this->middleware('permission:about_option_create', ['only' => ['option_create','option_store']]);
        $this->middleware('permission:about_option_edit', ['only' => ['option_edit','option_update']]);
        $this->middleware('permission:about_option_delete', ['only' => ['option_destroy']]);
    }

    public function index()
    {
        $items=About::orderBy('id')->get();
        return view('admin.setting.about.index', compact('items'), ['title' => $this->controller_title('index')]);
    }
    public function edit($id)
    {
        $url_back=$this->controller_title('url_back');
        $item=About::findOrFail($id);
        return view('admin.setting.about.edit',compact('url_back','item'), ['title' => $this->controller_title('edit')]);
    }
    public function update(AboutRequest $request,$id)
    {
        $item=About::findOrFail($id);
        try {
            About::where('id',$id)->update([
                'title' => $request->title,
                'text' => $request->text,
                'title1' => $request->title1,
                'text1' => $request->text1,
                'text2' => $request->text2,
                'text3' => $request->text3,
            ]);

            if ($request->hasFile('photo')) {
                if($item->photo)
                {
                    if(is_file($item->photo->path))
                    {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/setting/about' , '/');
                $item->photo()->save($photo);
            }
            store_lang($item,$request,['title','text','title1','text1','text2','text3'],'edit');
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function option_index()
    {
        $url_back=$this->controller_title('url_back');
        $items=AboutOption::orderBy('type')->get();
        return view('admin.setting.about.option.index', compact('items','url_back'), ['title' => $this->controller_title('option_index')]);
    }
    public function option_create()
    {
        $url_back=$this->controller_title('option_url_back');
        return view('admin.setting.about.option.create',compact('url_back'), ['title' => $this->controller_title('option_create')]);
    }
    public function option_store(AboutOptionRequest $request)
    {
        try {
            $item = AboutOption::create([
                'text' => $request->text,
                'type' => $request->type,
                'status' => $request->status,
            ]);
            //create
            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/about/option' . '/');
                $item->photo()->save($photo);
            }

            store_lang($item,$request,['text','status'],'create');

            return redirect($this->controller_title('option_url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function option_edit($id)
    {
        $url_back=$this->controller_title('option_url_back');
        $item=AboutOption::findOrFail($id);
        return view('admin.setting.about.option.edit',compact('url_back','item'), ['title' => $this->controller_title('option_edit')]);
    }
    public function option_update(AboutOptionRequest $request,$id)
    {
        $item=AboutOption::findOrFail($id);
        try {
            AboutOption::where('id',$id)->update([
                'text' => $request->text,
                'type' => $request->type,
                'status' => $request->status,
            ]);
            //edit
            if ($request->hasFile('photo')) {
                if($item->photo)
                {
                    if(is_file($item->photo->path))
                    {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/about/option' . '/');
                $item->photo()->save($photo);
            }

            store_lang($item,$request,['text','status'],'edit');

            return redirect($this->controller_title('option_url_back'))->with('flash_message',translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function option_destroy($id)
    {
        $item=AboutOption::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('option_url_back'))->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
