<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Models\Contact;
use App\Http\Requests\Setting\ContactRequest;
use App\Http\Controllers\Controller;
use App\Models\Photo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

use Spatie\Permission\Models\Permission;
class ContactController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return translateText('تماس با ما',lang_admin());
                break;
            case 'create':
                return 'افزودن  ندارد';
                break;
            case 'edit':
                return translateText('ویرایش تماس با ما',lang_admin());
                break;
            case 'url_back':
                return route('admin.contact.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:contact_list', ['only' => ['index','show']]);
        $this->middleware('permission:contact_edit', ['only' => ['edit','update']]);
    }

    public function index()
    {
        $items=Contact::orderBy('id')->get();
        return view('admin.setting.contact.index', compact('items'), ['title' => $this->controller_title('index')]);
    }
    public function show($id)
    {

    }
    public function create()
    {

    }
    public function store(ContactRequest $request)
    {

    }
    public function edit($id)
    {
        $url_back=$this->controller_title('url_back');
        $item=Contact::findOrFail($id);
        return view('admin.setting.contact.edit',compact('url_back','item'), ['title' => $this->controller_title('edit')]);
    }
    public function update(ContactRequest $request,$id)
    {
        $item=Contact::findOrFail($id);
        try {
            Contact::where('id',$id)->update([
                'title' => $request->title,
                'address_iframe' => $request->address_iframe,
                'address' => $request->address,
                'time' => $request->time,
                'phone' => $request->phone,
                'mobile' => $request->mobile,
                'fax' => $request->fax,
                'email' => $request->email,
                'telegram' => $request->telegram,
                'instagram' => $request->instagram,
                'facebook' => $request->facebook,
                'twitter' => $request->twitter,
                'whatsapp' => $request->whatsapp,
                'linkedin' => $request->linkedin,
                'youtube' => $request->youtube,
                'aparat' => $request->aparat,
                'whatsapp2' => $request->whatsapp2,
                'whatsapp_group' => $request->whatsapp_group,
            ]);
            if ($request->hasFile('photo')) {
                if($item->photo)
                {
                    if(is_file($item->photo->path))
                    {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/setting/contact' . '/');
                $item->photo()->save($photo);
            }

            store_lang($item,$request,['title','address','time'],'edit');
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function destroy($id)
    {

    }
}
