<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Http\Controllers\Controller;
use App\Models\Photo;
use Illuminate\Http\Request;

class MediaController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('رسانه',lang_admin());
                break;
            case 'url_back':
                return route('admin.media.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:media_list', ['only' => ['index']]);
        $this->middleware('permission:media_edit_alt', ['only' => ['edit_alt',]]);
    }

    public function index()
    {
        $items = Photo::where('status', 'active')->with('blog')->with('product')->orderByDesc('id')->get();
        return view('admin.setting.media.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function edit_alt($id, Request $request)
    {
        $item = Photo::findOrFail($id);

        try {
            $item->alt = $request->alt;

            $item->update();

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('با موفقیت ویرایش شد',lang_admin()));

        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجددا تلاش کنید',lang_admin()));
        }
    }

    public function show($id)
    {

    }

    public function create()
    {

    }

    public function store(Request $request)
    {

    }

    public function edit($id)
    {

    }

    public function update(SiteWordRequest $request, $id)
    {

    }

    public function destroy($id)
    {

    }


}
