<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Http\Controllers\Controller;
use App\Http\Requests\Setting\SettingSaleRequest;
use App\Models\Photo;
use App\Models\SettingSale;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class SettingSaleController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return translateText('تنظیمات پکیج',lang_admin());
                break;
            case 'create':
                return 'افزودن  ندارد';
                break;
            case 'edit':
                return translateText('ویرایش تنظیمات پکیج',lang_admin());
                break;
            case 'url_back':
                return route('admin.setting-sale.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:setting_sale_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:setting_sale_edit', ['only' => ['edit', 'update']]);
    }

    public function index()
    {
        $items = SettingSale::orderBy('id')->get();
        return view('admin.setting.sale.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {

    }

    public function store(SettingSaleRequest $request)
    {

    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = SettingSale::findOrFail($id);
        return view('admin.setting.sale.edit', compact('url_back', 'item'), ['title' => $this->controller_title('edit')]);
    }

    public function update(SettingSaleRequest $request, $id)
    {
        $item = SettingSale::findOrFail($id);
        try {
            SettingSale::where('id', $id)->update([
                'title' => $request->title,
                'text' => $request->text,
                'status' => $request->status,
                'price' => $request->price,
                'ex_month' => $request->ex_month,
            ]);
            //edit logo
            if ($request->hasFile('photo')) {
                if ($item->photo) {
                    if (is_file($item->photo->path)) {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/setting/sale' . '/');
                $item->photo()->save($photo);
            }
            store_lang($item, $request, ['title', 'text'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function destroy()
    {

    }
}
