<?php

namespace App\Http\Controllers\Admin\User;

use App\Models\User;
use App\Models\Photo;
use App\Models\PermissionCat;
use App\Http\Requests\User\UserRequest;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Str;


class UserController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return translateText('کاربران',lang_admin());
                break;
            case 'create':
                return translateText('افزودن کاربر',lang_admin());
                break;
            case 'edit':
                return translateText('ویرایش کاربر',lang_admin());
                break;
            case 'url_back':
                return route('admin.user.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:user_list', ['only' => ['index','show']]);
        $this->middleware('permission:user_create', ['only' => ['create','store']]);
        $this->middleware('permission:user_edit', ['only' => ['edit','update']]);
        $this->middleware('permission:user_delete', ['only' => ['destroy']]);
        $this->middleware('permission:user_status', ['only' => ['status']]);
        $this->middleware('permission:user_access', ['only' => ['permission_edit','permission_update']]);
        $this->middleware('permission:user_fast_login', ['only' => ['fast_login']]);
    }

    public function index(Request $request)
    {
        $user_id=User::role(['developer','supplier','buyer'])->select('id')->get()->toArray();
        if($request->role == 'supplier')
            $items=User::role(['supplier'])->where('id','!=',auth()->id())->orderByDesc('id')->get();
        elseif($request->role == 'buyer')
            $items=User::role(['buyer'])->where('id','!=',auth()->id())->orderByDesc('id')->get();
        else
            $items=User::WhereNotIN('id',$user_id)->where('id','!=',auth()->id())->orderByDesc('id')->get();

        return view('admin.user.index', compact('items'), ['title' => $this->controller_title('index')]);
    }
    public function show($id)
    {

    }
    public function create()
    {
        $url_back=$this->controller_title('url_back');
        $roles=Role::whereNotIN('name',['developer','buyer','supplier'])->get();
        return view('admin.user.create',compact('url_back','roles'), ['title' => $this->controller_title('create')]);
    }
    public function store(UserRequest $request)
    {
        try {
            $user = User::create([
                'name' => $request->name,
                'username' => $request->username,
                'password' => $request->password,
                'info' => $request->info,
            ]);
            $user->assignRole($request->role_name);

            //create User photo
            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/setting/profile' . '/');
                $user->photo()->save($photo);
            }

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت افزوده شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای افزودن به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function edit($id)
    {
        $url_back=$this->controller_title('url_back');
         $user=User::role(['developer'])->where('id',$id)->first();
         if($user)
         {
             abort(404);
         }
        $item=User::where('id',$id)->where('id','!=',auth()->id())->firstOrFail();
         $roles=Role::whereNotIN('name',['developer','buyer','supplier'])->get();

        return view('admin.user.edit',compact('url_back','item','roles'), ['title' => $this->controller_title('edit')]);
    }
    public function update(UserRequest $request,$id)
    {
        $user=User::role(['developer'])->where('id',$id)->first();
         if($user)
         {
             abort(404);
         }

        $item=User::where('id',$id)->where('id','!=',auth()->id())->firstOrFail();
        try {

            $item->name=$request->name;
            $item->username=$request->username;
            if (!blank($request->password)) {
                $item->password = $request->password;
            }
            $item->info=$request->info;
            $item->update();

            $item->syncRoles($request->role_name);

            //edit User photo
            if ($request->hasFile('photo')) {
                if($item->photo)
                {
                    if(is_file($item->photo->path))
                    {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/setting/profile' . '/');
                $item->photo()->save($photo);
            }

            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت ویرایش شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای ویرایش به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function destroy($id)
    {
        $user=User::role(['developer'])->where('id',$id)->first();
         if($user)
         {
             abort(404);
         }

        $item=User::where('id',$id)->where('id','!=',auth()->id())->firstOrFail();
        try {
            $item->delete();
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت حذف شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای حذف به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function status($id,$type,$status)
    {
        $user=User::role(['developer'])->where('id',$id)->first();
         if($user)
         {
             abort(404);
         }

        $item=User::where('id',$id)->where('id','!=',auth()->id())->firstOrFail();
        try {
            $item->$type=$status;
            $item->update();
            return redirect()->back()->with('flash_message', translateText('اطلاعات با موفقیت تغییر وضعیت شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای تغییر وضعیت به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }

    public function permission_edit($id)
    {
        $item = User::find($id);
        $role_permissions = [];
        foreach ($item->roles()->first()->permissions as $permission) {
            array_push($role_permissions, $permission->id);
        }
        $user_permissions = [];
        foreach ($item->permissions as $permission) {
            array_push($user_permissions, $permission->id);
        }
        $permission_cats = PermissionCat::whereHas('permissions')->orderBy('sort_by', 'asc');
        if (!auth()->user()->hasRole('developer')) {
            $permission_cats = $permission_cats->where('id', '>', 2);
        }
        $permission_cats = $permission_cats->get();
        return view('admin.user.permission', compact('item', 'role_permissions', 'user_permissions', 'permission_cats'), ['title' => 'مجوزها برای کاربر ' . $item->first_name . ' ' . $item->last_name]);
    }

    public function permission_update(Request $request, $id)
    {
        try {
            $item = User::find($id);
            $item->syncPermissions($request->input('permission'));
            return redirect($this->controller_title('url_back'))->with('flash_message', translateText('اطلاعات با موفقیت تغییر مجوز شد',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای تغییر مجوزها به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function fast_login(Request $request, $id)
    {
        try {
            if(!session()->has('admin_id'))
            {
                session(['admin_id'=>auth()->id()]);
                session(['back_url'=>url()->previous()]);

                auth()->loginUsingId($id);

                return redirect('/admin/profile');
            }
            return redirect()->back()->withInput()->with('err_message', translateText('برای فست لاگین به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای فست لاگین به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
    public function back_login(Request $request)
    {
        try {
            if(session()->has('admin_id'))
            {
                $url=session('back_url');
                $id=session('admin_id');

                session()->forget('back_url');
                session()->forget('admin_id');

                auth()->loginUsingId($id);
                return redirect($url);
            }
            return redirect()->back()->withInput()->with('err_message', translateText('برای برگشت به حساب خودم به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', translateText('برای برگشت به حساب خودم به مشکل خوردیم، مجدد تلاش کنید',lang_admin()));
        }
    }
}
