<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Laravel\Socialite\Facades\Socialite;

class LoginController extends Controller
{
    use AuthenticatesUsers;
    protected $redirectTo = '/dashboard';
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    public function redirectToGoogle()
    {
        return Socialite::driver('google')->redirect();
    }
    public function handleGoogleCallback()
    {
        $user = Socialite::driver('google')->user();

        $userAuth = User::query()->where('username',$user->email)->first();

        if ($userAuth) {
            $userAuthenticate = $userAuth;
        }else{
            $userAuthenticate = User::query()->create([
                'username' => $user->email,
                'name' => $user->name,
                'password' => rand(1111,9999)
            ]);

            $userAuthenticate->assignRole(session()->has('role_id') ? session('role_id') : 'buyer');
        }

        auth()->login($userAuthenticate);
        return redirect(route('admin.profile.show'));
    }
//    public function redirectToFacebook()
//    {
//        return Socialite::driver('facebook')->redirect();
//    }
//    public function handleFacebookCallback()
//    {
//        $user = Socialite::driver('facebook')->user();
//
//        $userAuth = User::query()->where('username',$user->email)->first();
//
//        if ($userAuth) {
//            $userAuthenticate = $userAuth;
//        }else{
//            $userAuthenticate = User::query()->create([
//                'username' => $user->email,
//                'name' => $user->name,
//                'password' => rand(1111,9999)
//            ]);
//            $userAuthenticate->assignRole(session('role_id'));
//        }
//        auth()->login($userAuthenticate);
//
//        return redirect(route('admin.profile.show'));
//    }
}
