<?php

namespace App\Http\Controllers\Front;

use App\Models\Conversation;
use App\Models\Landing;
use App\Models\ExhibitionDate;
use App\Models\Exhibition;
use App\Models\Photo;
use App\Models\SourcingMagazine;
use App\Models\SellYourProduct;
use App\Models\Transport;
use App\Models\Partner;
use App\Models\Banner;
use App\Models\Learning;
use App\Models\Rating;
use App\Models\User;
use App\Models\Feedback;
use App\Models\UserCertificate;
use App\Models\UserAddress;
use App\Models\Contact;
use App\Models\CountryCode;
use App\Models\Country;
use App\Models\ContactForm;
use App\Models\About;
use App\Models\AboutOption;
use App\Models\Blog;
use App\Models\Service;
use App\Models\Faq;
use App\Models\Setting;
use App\Models\Slider;
use App\Models\GalleryCategory;
use App\Models\ProductCategory;
use App\Models\Product;
use App\Models\Tag;
use App\Models\SearchHistory;
use App\Models\EmailVerification;

use App\Mail\Mail;
/*use App\Mail\SendVerifyMail;
use Illuminate\Support\Facades\Mail;*/
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\RateLimiter;

class HomeController extends Controller
{

    public function index()
    {
        //slider
        $sliders = Slider::checkStatus()->orderBy('sort')->get();
        //contact
        $contact_home = Contact::first();
        //blogs
        $blogs = Blog::checkStatus()->orderByDesc('id')->take(4)->get();
        //gallery
        $gallery = GalleryCategory::where('status_home', 'active')->checkStatus()->orderBy('sort')->take(6)->get();
        //productCategory
        $cats = ProductCategory::with(['children.children'])
            ->where('parent_id', null)
            ->checkStatus()
            ->orderBy('sort')
            ->get();
        //product
//        $products = Product::whereHas('user_active')->checkStatus()->whereHasServiceNo()->orderByDesc('id')->take(18)->get();
//        $product_service = Product::whereHas('user_active')->checkStatus()->whereHasServiceYes()->orderByDesc('id')->take(12)->get();
//        $products_top = Product::whereHas('user_active')->checkStatus()->orderByDesc('id')->take(11)->get();
        $banner1 = Banner::where('place', 'index_1')->orderBy('id')->get();
        $banner2 = Banner::where('status', 'active')->where('place', 'index_2')->orderBy('id')->get();
        $banner3 = Banner::where('status', 'active')->where('place', 'index_3')->orderBy('id')->get();
        $banner4 = Banner::where('status', 'active')->where('place', 'index_4')->orderBy('id')->get();
        $partners = Partner::checkStatus()->orderByDesc('id')->take(15)->get();
        $suppliers = User::role('supplier')
            ->with('photo', 'gallery.photo', 'products.photo')
            ->where('status', 'active')
            ->whereHas('products_active', function ($query) {
                $query->whereHas('c1_service_no');
            })
            ->inRandomOrder()
            ->take(8)
            ->get();

        $products_top = Product::whereHas('user_active')->whereHas('c1_service_no')->orderBy('seen', 'desc')
            ->take(11)
            ->get();
        // تعداد کل محصولات مورد نیاز
        $limit = 11;

// دریافت محصولات اضافه‌شده در ۲۴ ساعت اخیر
        $recentProducts = Product::whereHas('user_active')
            ->checkStatus()
            ->whereHas('c1_service_no')
            ->where('created_at', '>=', Carbon::now()->subHours(24))
            ->orderByDesc('id')
            ->take($limit)
            ->get();

// اگر تعداد محصولات اخیر کمتر از ۱۸ بود، مابقی را به‌صورت رندوم انتخاب کنید
        if ($recentProducts->count() < $limit) {
            $remaining = $limit - $recentProducts->count();

            // دریافت محصولات رندوم (به جز محصولاتی که قبلاً انتخاب شده‌اند)
            $randomProducts = Product::whereHas('user_active')
                ->checkStatus()
                ->whereHas('c1_service_no')
                ->whereNotIn('id', $recentProducts->pluck('id')) // جلوگیری از انتخاب محصولات تکراری
                ->inRandomOrder()
                ->take($remaining)
                ->get();

            // ادغام نتایج
            $products = $recentProducts->merge($randomProducts);
        } else {
            // اگر تعداد محصولات اخیر بیشتر یا مساوی ۱۸ بود، فقط همان‌ها را برگردانید
            $products = $recentProducts;
        }
        // تعداد کل محصولات مورد نیاز
//        $limits = 12;
//
//// دریافت محصولات اضافه‌شده در ۲۴ ساعت اخیر
//        $recentProducts_service = Product::whereHas('user_active')
//            ->checkStatus()
//            ->whereHas('c1_service_yes')
//            ->where('created_at', '>=', Carbon::now()->subHours(24))
//            ->orderByDesc('id')
//            ->take($limits)
//            ->get();
//
//// اگر تعداد محصولات اخیر کمتر از ۱۸ بود، مابقی را به‌صورت رندوم انتخاب کنید
//        if ($recentProducts_service->count() < $limits) {
//            $remainings = $limits - $recentProducts_service->count();
//
//            // دریافت محصولات رندوم (به جز محصولاتی که قبلاً انتخاب شده‌اند)
//            $randomProducts_service = Product::whereHas('user_active')
//                ->checkStatus()
//                ->whereHas('c1_service_yes')
//                ->whereNotIn('id', $recentProducts_service->pluck('id')) // جلوگیری از انتخاب محصولات تکراری
//                ->inRandomOrder()
//                ->take($remainings)
//                ->get();
//
//            // ادغام نتایج
//            $product_service = $recentProducts_service->merge($randomProducts_service);
//        } else {
//            // اگر تعداد محصولات اخیر بیشتر یا مساوی ۱۸ بود، فقط همان‌ها را برگردانید
//            $product_service = $recentProducts_service;
//        }
        $top_product_service = Product::whereHas('user_active')
            ->checkStatus()
            ->where('for_we','no')
            ->with(['icon','c1','c2','c3','c4'])
            ->whereHas('c1_service_yes')
            ->orderBy('seen', 'desc')
            ->take(6)
            ->get();

        $topProviders = User::topServiceProviders()
            ->with(['photo', 'services' => function($q) {
                $q->checkStatus()
                    ->orderByDesc('seen')
                    ->take(6);
            }])
            ->get();
        $our_service = Product::whereHas('user_active')
            ->checkStatus()
            ->where('for_we','yes')
            ->with(['icon','c1','c2','c3','c4'])
            ->whereHas('c1_service_yes')
            ->orderBy('seen', 'desc')
            ->take(8)
            ->get();
        $learnings = Learning::with('photo', 'video')->checkStatus()->orderByDesc('id')->take(3)->get();
        $faqs = Faq::checkStatus()->orderBy('sort')->take(7)->get();
        $ratings = Rating::where('status', '=', 'active')->take(5)->get();
        $exhibitions_smart = Exhibition::with('photo')->where('status', 'active')
            ->where('type', 'smart')
            ->orderBy('created_at', 'desc')
            ->take(4)
            ->get();
        
        $exhibitions_online = Exhibition::with('photo')->where('status', 'active')
            ->where('type', 'online')
            ->orderBy('created_at', 'desc')
            ->take(4)
            ->get();
        $stories = Feedback::with('photo')->where('status','active')->whereNotNull('story')->orderBy('id')->take(5)->get();
        $videos = Feedback::with('video')->where('status','active')->whereNull('story')->orderBy('id')->take(5)->get();

        return view('front.index', compact('our_service','exhibitions_online', 'exhibitions_smart', 'learnings', 'ratings', 'faqs', 'sliders', 'cats', 'contact_home', 'blogs', 'gallery', 'products', 'products_top', 'banner1', 'banner2','banner3', 'banner4', 'partners', 'suppliers', 'top_product_service','topProviders','stories','videos'), ['title' => read_lang_word('title-home')]);
    }


    public function set_chat($sender_id, $receiver_id)
    {
        if ($sender_id == $receiver_id)
            return ['status' => 0, 'title' => read_lang_word('unsuccessful'), 'msg' => read_lang_word('msg-err-form')];
        $sender = User::find($sender_id);
        $receiver = User::find($receiver_id);
        if (!$sender || !$receiver)
            return ['status' => 0, 'title' => read_lang_word('unsuccessful'), 'msg' => read_lang_word('msg-err-form')];
        $item = Conversation::where('sender_id', $sender_id)->where('receiver_id', $receiver_id)->orWhere('sender_id', $receiver_id)->where('receiver_id', $sender_id)->first();
        if ($item) {
            $html = view('front.product.includes.iframe', compact('sender_id', 'receiver_id'))->render();
            return ['status' => 1, 'html' => $html];
        }
        try {
            Conversation::create([
                'sender_id' => $sender_id,
                'receiver_id' => $receiver_id,
                'status' => 'active',
            ]);
            $html = view('front.product.includes.iframe', compact('sender_id', 'receiver_id'))->render();
            return ['status' => 1, 'html' => $html];
        } catch (\Exception $e) {
            return ['status' => 0, 'title' => read_lang_word('unsuccessful'), 'msg' => read_lang_word('msg-err-form')];
        }
    }

    public function about()
    {
        $item = About::where('type', 'about')->first();
        $items_m = AboutOption::checkStatus()->where('type', 'mission')->get();
        $items_w = AboutOption::checkStatus()->where('type', 'work')->get();
        $items_c = AboutOption::checkStatus()->where('type', 'corporate')->get();
        return view('front.about', compact('item', 'items_m', 'items_w', 'items_c'), ['title' => read_lang_word('title-about')]);
    }

    public function faq()
    {
        $items = Faq::checkStatus()->orderBy('sort')->get();
        return view('front.faq', compact('items'), ['title' => read_lang_word('title-faq')]);
    }

    public function signupnew()
    {
        $about = About::where('type', 'register')->first();
        $countries = Country::all();
        return view('front.signup-new', compact('about','countries'), ['title' => read_lang_word('title-signupnew')]);
    }

    public function loginnew()
    {
        return view('front.login-new', ['title' => read_lang_word('title-loginnew')]);
    }

    public function verify_email(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'agree-terms' => 'required|accepted'
        ]);

        $email = $request->email;

        $key = 'verify-email:' . $email;
        if (RateLimiter::tooManyAttempts($key, 5)) {
            return response()->json([
                'success' => false,
                'message' => 'Too many attempts. Please try again later.'
            ], 429);
        }

        try {
            $code = rand(1000, 9999);
            $expiresAt = now()->addMinutes(10);

            EmailVerification::create([
                'email' => $email,
                'code' => $code,
                'expires_at' => $expiresAt,
            ]);


            $text='<div dir="ltr">';
            $text.='<h1 style="text-align: center;font-family: cursive">';
            $text.='Verification Code: ';
            $text.='</h1>';
            $text.='<h1 style="text-align: center;font-size: 50px">';
            $text.='<strong dir="ltr" style="letter-spacing: 20px;color:#003c70;font-family: cursive">';
            $text.=$code;
            $text.='</strong>';
            $text.='</h1>';
            $text.='</div>';
            $details = [
                'subject' => 'Notification Mainexpo',
                'title' => 'Notification Mainexpo',
                'body' => $text
            ];
            \Mail::to($email)->send(new Mail($details));

            RateLimiter::hit($key, 3600);

            return response()->json([
                'success' => true,
                'message' => 'Verification code sent successfully.'
            ]);
        } catch (\Exception $e) {
            \Log::error('Email verification error: ' . $e->getMessage());
            return response()->json([
                'success' => false,
                'message' => 'Failed to send verification code.'
            ], 500);
        }
    }

    public function verify_code(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'code' => 'required|digits:4'
        ]);

        $email = $request->email;
        $code = $request->code;

        $verification = EmailVerification::where('email', $email)
            ->where('code', $code)
            ->where('expires_at', '>', now())
            ->where('used', false)
            ->first();

        if (!$verification) {
            return response()->json([
                'success' => false,
                'message' => read_lang_word('invalid-or-expired-verification-code')
            ], 422);
        }

        $verification->update(['used' => true]);

        session(['email_verified' => true, 'verified_email' => $verification->email]);

        return response()->json([
            'success' => true,
            'message' => read_lang_word('email-successfully-verified')
        ]);
    }

    public function contact()
    {
        $item = Contact::first();
        $items = Contact::get();
        return view('front.contact', compact('item', 'items'), ['title' => read_lang_word('title-contact')]);
    }

    public function contact_post(Request $request)
    {
        if (isset($request->captcha2)) {
            $this->validate($request, [
                'name' => 'required|max:200',
                'email' => 'required|email',
                'phone' => 'nullable|numeric',
                'subject' => 'required|max:250',
                'message' => 'required',
                'captcha2' => 'required',
            ]);
            if ($request->captcha2 != session('captcha_code2')) {
                return ['status' => 0, 'title' => read_lang_word('unsuccessful'), 'message' => read_lang_word('captcha-err')];
            }
        } else {
            $this->validate($request, [
                'name' => 'required|max:200',
                'email' => 'required|email',
                'phone' => 'nullable|numeric',
                'subject' => 'required|max:250',
                'message' => 'required',
                'captcha' => 'required',
            ]);
            if ($request->captcha != session('captcha_code')) {
                return ['status' => 0, 'title' => read_lang_word('unsuccessful'), 'message' => read_lang_word('captcha-err')];
            }
        }
        try {
            $item = ContactForm::create([
                'name' => $request->name,
                'email' => $request->email,
                'phone' => $request->phone,
                'subject' => $request->subject,
                'message' => $request->message,
            ]);
            return ['status' => 1, 'title' => read_lang_word('unsuccessful'), 'message' => read_lang_word('msg-success-form')];
        } catch (\Exception $e) {
            return ['status' => 0, 'title' => read_lang_word('unsuccessful'), 'message' => read_lang_word('msg-err-form')];
        }
    }

    public function service_list()
    {
        $items = Service::checkStatus()->orderBy('sort')->paginate(24);
        return view('front.service.index', compact('items'), ['title' => read_lang_word('title-service')]);
    }

    public function blog_list()
    {
        $items = Blog::checkStatus()->orderBy('sort')->paginate(12);
        return view('front.blog.index', compact('items'), ['title' => read_lang_word('title-blog')]);
    }

    public function blog_show($slug)
    {
        $item = Blog::where('slug', $slug)->checkStatus()->firstOrFail();
        $item->seen += 1;
        $item->update();
        //tag
        $tags = Tag::whereIN('id', $item->tags)->checkStatus()->get();
        //last items
        $items_last = Blog::orderByDesc('id')->where('id', '!=', $item->id)->checkStatus()->take(5)->get();
        //seen
        $items_seen = Blog::orderByDesc('seen')->where('id', '!=', $item->id)->checkStatus()->take(5)->get();
        return view('front.blog.show', compact('item', 'items_last', 'items_seen', 'tags'), ['title' => read_lang($item, 'title')]);
    }

    public function tag_show($slug)
    {
        $item = Tag::where('slug', $slug)->checkStatus()->firstOrFail();
        //last items
        $blogs = Blog::orderByDesc('id')->where('tags', 'LIKE', '%"' . $item->id . '"%')->checkStatus()->paginate('24');
        return view('front.tag.show', compact('item', 'blogs'), ['title' => read_lang($item, 'title')]);
    }

    public function product_list($cat_slug = 'all')
    {
        $items = Product::whereHas('user_active')->orderByDesc('id');
        $title = read_lang_word('title-product');
        $cat_id = $cat_slug;
        if ($cat_slug != 'all') {
            $category = ProductCategory::where('slug', $cat_slug)->firstOrFail();
//            $cats_id=$this->return_cat_id($category);

            $cat_id = $category->id;
            $title = read_lang_word('title-product') . ' ' . read_lang($category, 'title');
            $items = $items->where(function ($query) use ($cat_id) {
                $query->where('c_1', $cat_id)
                    ->orWhere('c_2', $cat_id)
                    ->orWhere('c_3', $cat_id)
                    ->orWhere('c_4', $cat_id);
            });
        }
        $items = $items->checkStatus()->paginate(24);

        $cats = ProductCategory::where('parent_id', null)->checkStatus()->orderBy('sort')->get();
        return view('front.product.index', compact('items', 'cats', 'cat_id'), ['title' => $title]);
    }

    public $return_cats_id = [];

    public function return_cat_id($cat)
    {
        array_push($this->return_cats_id, $cat->id);
        if (count($cat->childs_active)) {
            foreach ($cat->childs_active as $child) {
                $this->return_cat_id($child);
            }
        }

        return $this->return_cats_id;
    }

    public function product_show($slug)
    {
        $item = Product::whereHas('user_active')->checkStatus()->where('slug', $slug)->firstOrFail();
        $category = ProductCategory::where('id', $item->category_id)->firstOrFail();
        $item->seen += 1;
        $item->update();
        //product Similar
        $items_similar = Product::whereHas('user_active')->where('id', '!=', $item->id)->where('category_id', $category->id)->checkStatus()->orderByDesc('id')->take(20)->get();

        $user = $item->user;
        if (!$user)
            abort(404);

        $start = Carbon::parse($user->verify_date)->format('Y-m-d 23:59:59');
        $end = Carbon::now()->format('Y-m-d 00:00:00');
        $start = Carbon::parse($start);
        $end = Carbon::parse($end);
        $days = round($end->diffInDays($start, false));
        $addresses = UserAddress::where('user_id', $user->id)->orderBy('city')->get();

        $conversation_auth = Conversation::where('sender_id', auth()->id())->where('receiver_id', $user->id)->orWhere('sender_id', $user->id)->where('receiver_id', auth()->id())->first();

        return view('front.product.show', compact('item', 'items_similar', 'days', 'category', 'user', 'addresses', 'conversation_auth'), ['title' => read_lang($item, 'title'), 'cat_title' => read_lang($category, 'title'), 'cat_slug' => $category->slug]);
    }

    public function supplier_show($id, Request $request)
    {
        $sett = Setting::first();
        $user = User::role('supplier')->where('status', 'active')->where('u_id', $id)->firstOrFail();
        $products = Product::checkStatus()->where('user_id', $user->id);
        $cat_id = null;
        $cat_id1 = null;
        $cat_id2 = null;
        $cat_id3 = null;
        $cat_id4 = null;
        if (isset($request->cat_id)) {
            if (count($request->cat_id) > 3) {
                $cat_id4 = $request->cat_id[3];
                $cat_id3 = $request->cat_id[2];
                $cat_id2 = $request->cat_id[1];
                $cat_id1 = $request->cat_id[0];

                $cat_id = $request->cat_id[3];
            } elseif (count($request->cat_id) > 2) {
                $cat_id3 = $request->cat_id[2];
                $cat_id2 = $request->cat_id[1];
                $cat_id1 = $request->cat_id[0];

                $cat_id = $request->cat_id[2];
            } elseif (count($request->cat_id) > 1) {
                $cat_id2 = $request->cat_id[1];
                $cat_id1 = $request->cat_id[0];

                $cat_id = $request->cat_id[1];
            } elseif (count($request->cat_id)) {
                $cat_id1 = $request->cat_id[0];
                $cat_id = $request->cat_id[0];
            }

            $category = ProductCategory::where('id', $cat_id)->first();
            if ($category) {
//                $cats_id=$this->return_cat_id($category);

                $products = $products->where(function ($query) use ($cat_id) {
                    $query->where('c_1', $cat_id)
                        ->orWhere('c_2', $cat_id)
                        ->orWhere('c_3', $cat_id)
                        ->orWhere('c_4', $cat_id);
                });
            }
        }
        $products = $products->paginate(18);
        $cats = ProductCategory::whereNull('parent_id')->whereHas('products_c1', function ($p) use ($user) {
            $p->where('user_id', $user->id);
        })->get();

        $gallery = GalleryCategory::where('user_id', $user->id)->where('status', 'active')->whereHas('photo')->whereHas('gallery_p')->orderBy('sort')->get();
        $gallery_v = GalleryCategory::where('user_id', $user->id)->where('status', 'active')->whereHas('photo')->whereHas('gallery_v')->orderBy('sort')->get();

        $certificates = UserCertificate::where('user_id', $user->id)->whereHas('photo')->orderBy('type_title')->get();

        $addresses = UserAddress::where('user_id', $user->id)->orderBy('city')->get();

        $user->seen += 1;
        $user->update();

        $package = true;
        $start = Carbon::parse($user->verify_date)->format('Y-m-d 23:59:59');
        $end = Carbon::now()->format('Y-m-d 00:00:00');
        $start = Carbon::parse($start);
        $end = Carbon::parse($end);
        $days = round($end->diffInDays($start, false));

        return view('front.supplier.show', compact('sett', 'user', 'cat_id1', 'cat_id2', 'cat_id3', 'cat_id4', 'products', 'cats', 'gallery', 'gallery_v', 'certificates', 'addresses', 'days'), ['title' => $user->name]);
    }

    public function gallery()
    {
        $items = GalleryCategory::whereDoesntHave('user', function ($q) {
            $q->role('supplier');
        })->where('status', 'active')->orderBy('sort')->paginate(24);
        return view('front.gallery.index', compact('items'), ['title' => read_lang_word('title-gallery')]);
    }

    public function terms()
    {
        $item = About::where('type', 'terms')->first();
        return view('front.rules', compact('item'), ['title' => read_lang_word('title-terms')]);
    }

    public function hyperlink()
    {
        $item = About::where('type', 'hyperlink')->first();
        return view('front.rules', compact('item'), ['title' => read_lang_word('title-hyperlink')]);
    }

    public function suggest(Request $request)
    {
        $query = $request->input('query');
        $type = $request->input('type1');
        $lang_site = lang();
        $results = [];

        if ($type == 'products') {
            $items = Product::whereHas('user_active')->whereHas('c1_service_no')->checkStatus();
            if ($lang_site == 'en')
                $items = $items->where('title', 'LIKE', "%{$query}%");
            else
                $items = $items->whereHas('langs', function ($lang) use ($query, $lang_site) {
                    $lang->where('lang', $lang_site)->where('col_name', 'title')->where('text', 'LIKE', "%{$query}%");
                });
            $items = $items->orderByDesc('id')->take(15)
                ->get()
                ->map(function ($item) {
                    return [
                        'type' => 'Product',
                        'value' => $item->id,
                        'text' => read_lang($item, 'title')
                    ];
                });
        } elseif ($type == 'services') {
            $items = Product::whereHas('user_active')->whereHas('c1_service_yes')->checkStatus();
            if ($lang_site == 'en')
                $items = $items->where('title', 'LIKE', "%{$query}%");
            else
                $items = $items->whereHas('langs', function ($lang) use ($query, $lang_site) {
                    $lang->where('lang', $lang_site)->where('col_name', 'title')->where('text', 'LIKE', "%{$query}%");
                });
            $items = $items->orderByDesc('id')->take(15)
                ->get()
                ->map(function ($item) {
                    return [
                        'type' => 'Service',
                        'value' => $item->id,
                        'text' => read_lang($item, 'title')
                    ];
                });
        } elseif ($type == 'suppliers') {
            $items = User::role('supplier')->where('status', 'active');
            $items = $items->orderByDesc('id')->where('name', 'LIKE', "%{$query}%")
                ->take(15)
                ->get()
                ->map(function ($item) {
                    return [
                        'type' => 'Supplier',
                        'value' => $item->id,
                        'text' => $item->name
                    ];
                });
        } elseif ($type == 'buyers') {

        }

        $results = $items->toArray();


        return response()->json($results);
    }

    public function search(Request $request)
    {
        $search = $request->search;
        $SelectId = $request->SelectId;
        $type = $request->type;
        if ($type == 'products') {
            if ((int)$SelectId > 0) {
                $item = Product::whereHas('user_active')->checkStatus()->find($SelectId);
                if ($item)
                    return redirect()->route('front.product.show', $item->slug);
            }
            $products = Product::whereHas('user_active')->whereHas('c1_service_no')->where('title', 'LIKE', '%' . $search . '%')->checkStatus()->orderByDesc('id')->paginate(24);
            if (!count($products))
                return redirect()->back()->withInput()->with('err_message', read_lang_word('msg-err-not-found'));

            return view('front.search.product', compact('products'), ['title' => read_lang_word('titlesearchpage') . ': ' . $search]);
        } elseif ($type == 'services') {
            if ((int)$SelectId > 0) {
                $item = Product::whereHas('user_active')->checkStatus()->find($SelectId);
                if ($item)
                    return redirect()->route('front.product.show', $item->slug);
            }
            $products = Product::whereHas('user_active')->whereHas('c1_service_yes')->where('title', 'LIKE', '%' . $search . '%')->checkStatus()->orderByDesc('id')->paginate(24);
            if (!count($products))
                return redirect()->back()->withInput()->with('err_message', read_lang_word('msg-err-not-found'));

            return view('front.search.product', compact('products'), ['title' => read_lang_word('titlesearchpage') . ': ' . $search]);
        } elseif ($type == 'suppliers') {
            if ((int)$SelectId > 0) {
                $item = User::role('supplier')->where('status', 'active')->find($SelectId);
                if ($item)
                    return redirect()->route('front.supplier.show', $item->u_id);

                $suppliers = User::role('supplier')->where('status', 'active')->where('name', 'LIKE', "%{$search}%")->whereHas('products_active')->get();

                return view('front.search.supplier', compact('suppliers'), ['title' => read_lang_word('titlesearchpage') . ': ' . $search]);
            }
        }

        return redirect()->back()->withInput()->with('err_message', read_lang_word('msg-err-not-found'));
    }

    public function import_export_services()
    {
        $top = Setting::first();
        $items_m = Transport::where('type', 'multimodal_transports')->checkStatus()->orderBY('sort')->get();
        $items_s = Transport::where('type', 'sea_transportation')->checkStatus()->orderBY('sort')->get();
        $items_a = Transport::where('type', 'air_freight')->checkStatus()->orderBY('sort')->get();
        $items_l = Transport::where('type', 'land_freight')->checkStatus()->orderBY('sort')->get();
        $items_f = Transport::where('type', 'freight_agents')->checkStatus()->orderBY('sort')->get();
        $items_c = Transport::where('type', 'customs_clearance_services')->checkStatus()->orderBY('sort')->get();
        return view('front.pages.import_export_services', compact('items_m', 'items_s', 'items_a', 'items_l', 'items_f', 'items_c', 'top'), ['title' => read_lang_word('import-export-services')]);
    }

    public function sourcing_magazine()
    {
        $top = Setting::first();
        $items = SourcingMagazine::checkStatus()->orderBY('sort')->get();
        $cats = ProductCategory::checkStatus()->whereHas('sourcing_magazine')->where('parent_id', null)->orderBY('sort')->get();
        $cat_id = null;
        if (count($cats))
            $cat_id = $cats[0]->id;
//        $cats=ProductCategory::checkStatus()->where('parent_id',null)->orderBY('sort')->get();
        return view('front.pages.sourcing_magazine', compact('items', 'cats', 'top', 'cat_id'), ['title' => read_lang_word('sourcing-magazine')]);
    }

    public function sell_your_products()
    {
        return view('front.pages.sell_your_products', ['title' => read_lang_word('sell-your-products')]);
    }

    public function sell_your_products_post(Request $request)
    {
        $this->validate($request, [
            'c_name' => 'required|max:120',
            'f_name' => 'required|max:120',
            'l_name' => 'required|max:120',
            'email' => 'required|email',
            'phone' => 'nullable',
            'date_start' => 'required|date|date_format:Y-m-d|after_or_equal:today',
            'date_end' => 'required|date|date_format:Y-m-d|after_or_equal:date_start',
            'text' => 'required',
            'captcha' => 'required',
        ]);
        if ($request->captcha != session('captcha_code')) {
            return ['status' => 0, 'message' => read_lang_word('captcha-err')];
        }

        try {
            $item = SellYourProduct::create([
                'c_name' => $request->c_name,
                'f_name' => $request->f_name,
                'l_name' => $request->l_name,
                'email' => $request->email,
                'phone' => $request->phone,
                'date_start' => $request->date_start,
                'date_end' => $request->date_end,
                'text' => $request->text,
            ]);
            return redirect()->back()->with('flash_message', read_lang_word('msg-success-form'));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', read_lang_word('msg-err-form'));
        }
    }

    public function landing($slug)
    {
        $item = Landing::where('slug', $slug)->whereHas('details')->firstOrFail();
        $dates = ExhibitionDate::checkStatus()->orderBy('from_date')->get()->groupBy('from_date');
        return view('front.pages.landing', compact('item', 'slug', 'dates'), ['title' => read_lang($item, 'title')]);
    }

    public function feedback_store(Request $request)
    {
        if (!auth()) {
            return response()->json([
                'success' => false,
                'message' => __('Please log in to your account.')
            ]);
        }
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'company' => 'nullable|string|max:255',
            'story' => 'required|string',
            'logo' => 'required|image|max:255',
        ]);
        $date = [
            'user_id' => auth()->id(),
            'full_name' => $request->name,
            'email' => $request->email,
            'company_name' => $request->company,
            'story' => $request->story,
        ];
        try {
            $item = Feedback::create($date);
            if ($request->hasFile('logo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->logo, 'assets/admin/uploads/feedback/image/');
                $item->photo()->save($photo);
            }
            return response()->json([
                'success' => true,
                'message' => __('Your feedback has been submitted successfully.')
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => __('Failed to submit feedback. Please try again later.')
            ], 500);
        }
    }
    public function feedback_video_store(Request $request)
    {
        if (!auth()) {
            return response()->json([
                'success' => false,
                'message' => __('Please log in to your account.')
            ]);
        }
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'video' => "required|mimes:mp4,mov|max:10240",
        ]);
        $date = [
            'user_id' => auth()->id(),
            'full_name' => $request->name,
            'email' => $request->email,
        ];
        try {
            $item = Feedback::create($date);
            if ($request->hasFile('video')) {
                $photo = new Photo();
                $photo->type = 'video';
                $photo->path = file_store($request->video, 'assets/admin/uploads/feedback/video/');
                $item->photo()->save($photo);
            }
            return response()->json([
                'success' => true,
                'message' => __('Your feedback has been submitted successfully.')
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => __('Failed to submit feedback. Please try again later.')
            ], 500);
        }
    }
}
