<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Redirect;

class RedirectMidd
{

    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */

    public function handle($request, Closure $next)
    {
        $url = $request->fullUrl();
        $url = str_replace('http://', 'https://', $url);
        $url=urldecode($url);
        $url_slugs=str_replace(route('front.index'),'',$url);
//        $url_slug=explode('?',$url_slug);
        $url_slugs=explode('/',$url_slugs);
        $url_slug=$url_slugs[0];

        if(blank($url_slug) && count($url_slugs) > 1)
        {
            $url_slug=$url_slugs[1];
        }
        $redirect = Redirect::where('from', $url)->where('status','active')->first();
        if (is_null($redirect)) {
            $redirect = Redirect::where('from', $url . '/')->where('status','active')->first();
            if (is_null($redirect)) {
                $redirect = Redirect::where('from', explode('?', $url)[0])->where('status','active')->first();
                if (is_null($redirect)) {
                    $redirect = Redirect::where('from', explode('?', $url)[0] . '/')->where('status','active')->first();
                    if (is_null($redirect)) {
                        $redirect = Redirect::where('from','LIKE','%'.$url_slug.'%')->where('groups','yes')->where('status','active')->first();
                    }
                }
            }
        }
//        if($request->r== 125)
//        {
//            dd($redirect,$url,$url_slug);
//        }
        if ($redirect) {
            if ($redirect->type == 410) {
                abort(410);
            }
            elseif ($redirect->type == 404) {
                abort(404);
            }
            elseif ($redirect->type == 301) {
                if($redirect->groups == 'yes')
                {
                    $original_url=$request->path();
                    $index_url=route('front.index').'/';
                    $preg_match=str_replace($index_url,'',$redirect->from);
                    if (stripos($original_url,$preg_match) !== false)
                    {
                        header("Location: $redirect->to", true, 301);
                        exit();
                    }
                }
                else
                {
                    header("Location: $redirect->to", true, 301);
                    exit();
                }
            }
            elseif ($redirect->type == 302) {
                header("Location: $redirect->to", true, 302);
                exit();
            }
        }

        return $next($request);

    }
}