<?php

namespace App\Http\Requests\Blog;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class BlogRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'title' => 'required|max:240',
                    'author' => 'required|max:240',
                    'text' => 'required',
                    'category_id' => 'required|exists:blog_categories,id',
                    'slug' => 'required|max:300|unique:blogs,slug',
                    'meta_description' => 'nullable|max:300',
                    'meta_title' => 'nullable|max:255',
                    'status' => 'required',
                    'photo' => "required|image|mimes:jpeg,jpg,webp|max:512",
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');

                return [
                    'title' => 'required|max:240',
                    'author' => 'required|max:240',
                    'text' => 'required',
                    'category_id' => 'required|exists:blog_categories,id',
                    'slug' => 'required|max:300|unique:blogs,slug,'.$id,
                    'meta_description' => 'nullable|max:300',
                    'meta_title' => 'nullable|max:255',
                    'status' => 'required',
                    'photo' => "nullable|image|mimes:jpeg,jpg,webp|max:512",
                ];
            }
            default:
                break;
        }
    }
}
