<?php

namespace App\Http\Requests\Company;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class BusinessInformationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'bussiness_type' => 'required|array|min:1',
                    'bussiness_type.*' => 'string|exists:company_form,title',
                    'category_id' => 'required|array',
                    'category_id.*' => 'exists:product_categories,id',
                    'registration_number' => 'nullable|string|max:255',
                    'ownership_model' => 'nullable|string|exists:company_form,title',
                    'main_product_keywords' => 'required|array|min:1',
                    'main_product_keywords.*' => 'string|max:255',
                    'tax_identification_number' => 'nullable|string|max:255',
                ];
            }
            default:
                break;
        }
    }
}
