<?php

namespace App\Http\Requests\Company;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class GeneralInformationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'company_name' => 'required|max:255',
                    'company_ceo' => 'nullable|max:255',
                    'company_introduction' => 'required|max:400',
                    'company_description' => 'required',
                    'year_of_established' => 'required',
                    'number_of_employees' => 'nullable|max:255',
                    'website' => 'nullable|max:500|url',
                    'accepted_currencies' => 'required|max:255',
                    'payment_terms' => 'required|max:255',
                    'oem_services' => 'required|in:yes,no',
                    'working_days' => 'required|max:255',
                    'logo' => "nullable|image|mimes:jpeg,jpg,png,webp,gif|max:1024",
                    'banner1' => "nullable|image|mimes:jpeg,jpg,png,webp,gif|max:2024",
                    'banner2' => "nullable|image|mimes:jpeg,jpg,png,webp,gif|max:2024",
                    'brochure' => "nullable|mimes:pdf|max:15240",
                    'video' => "nullable|mimes:mp4,mov|max:10240",
                    'gallery' => "nullable|array|max:6",
                    'gallery.*' => "nullable|image|mimes:jpeg,jpg,png,webp|max:5024",
                ];
            }
            default:
                break;
        }
    }
}
