<?php

namespace App\Http\Requests\Company;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class TradingInformationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'import_export_license' => 'required|in:Yes,No',
                    'annual_turnover' => 'required|string|exists:company_form,title',
                    'export_revenue' => 'required|string|exists:company_form,title',
                    'export_percentage' => 'nullable|integer|min:0|max:100',
                    'total_capitalization' => 'required|string|exists:company_form,title',
                    'nearest_port' => 'required|exists:countries,id',
                    'terms_of_trades' => 'required|array|min:1',
                    'terms_of_trades.*' => 'string|exists:rfq_form,title1',
                ];
            }
            default:
                break;
        }
    }
}
