<?php

namespace App\Http\Requests\Other;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class ExhibitionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'title' => 'required|max:255',
                    'text' => 'nullable',
                    'slug' => 'required|max:300',
                    'industry' => 'required|max:300',
                    'start_date' => 'required|date',
                    'end_date' => 'required|date|after_or_equal:start_date',
                    'type' => 'required',
                    'status' => 'required',
                    'photo' => "required|image|mimes:jpeg,jpg,png,webp|max:512",
                    'link' => 'nullable|url',
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'title' => 'required|max:255',
                    'text' => 'nullable',
                    'slug' => 'required|max:300',
                    'industry' => 'required|max:300',
                    'start_date' => 'required|date',
                    'end_date' => 'required|date|after_or_equal:start_date',
                    'type' => 'required',
                    'status' => 'required',
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                    'link' => 'nullable|url',
                ];
            }
            default:
                break;
        }
    }
}
