<?php

namespace App\Http\Requests\Other;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class FaqRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'question' => 'required|max:300',
                    'answer' => 'required',
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'question' => 'required|max:300',
                    'answer' => 'required',
                ];
            }
            default:
                break;
        }
    }
}
