<?php

namespace App\Http\Requests\Other;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class IndustryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'industry_id' => 'required',
                    'title' => 'required|max:255',
                    'slug' => 'required|max:255|unique:product_categories,slug',
                ];
            }
            case 'PATCH':
            {
                $id = $this->request->get('id');
                return [
                    'industry_id' => 'required',
                    'title' => 'required|max:255',
                    'slug' => 'required|max:255|unique:product_categories,slug,' . $id,
                ];
            }
            default:
                break;
        }
    }
}
