<?php

namespace App\Http\Requests\Other;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class TransportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'title' => 'required|max:75',
                    'about' => 'required|max:3000',
                    'service' => 'required|max:3000',
                    'photos.*' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                    'video' => "nullable|mimes:mp4,mov|max:51200",
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'title' => 'required|max:75',
                    'about' => 'required|max:3000',
                    'service' => 'required|max:3000',
                    'photos.*' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                    'video' => "nullable|mimes:mp4,mov|max:51200",
                ];
            }
            default:
                break;
        }
    }
}
