<?php

namespace App\Http\Requests\Setting;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class AboutOptionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'text' => 'required|max:200',
                    'photo' => "required|image|mimes:jpeg,jpg,webp,png|max:512",
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'text' => 'required|max:200',
                    'photo' => "nullable|image|mimes:jpeg,jpg,webp,png|max:512",
                ];
            }
            default:
                break;
        }
    }
}
