<?php

namespace App\Http\Requests\Setting;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class MetaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'name_page' => 'required|max:250',
                    'title_page' => 'required|max:250',
                    'link' => "required|url|unique:metas",
                    'canonical' => "nullable|url",
                    'keyword' => "required|max:500",
                    'description' => "required|max:500",
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');

                return [
                    'name_page' => 'required|max:250',
                    'title_page' => 'required|max:250',
                    'link' => 'required|url|unique:metas,link,'.$id,
                    'canonical' => "nullable|url",
                    'keyword' => "required|max:500",
                    'description' => "required|max:500",
                ];
            }
            default:
                break;
        }
    }
}
