<?php

namespace App\Http\Requests\Setting;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class SettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {

            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'title' => 'required|max:150',
                    'description' => 'nullable|max:500',
                    'keywords' => 'nullable|max:500',
                    'logo' => "nullable|image|mimes:png,webp|max:256",
                    'icon' => "nullable|mimes:png,ico,webp|max:256",
                    'header' => "nullable|mimes:webp,png,webp|max:512",
                    'login' => "nullable|mimes:webp,png,webp|max:512",
                ];
            }
            default:
                break;
        }
    }
}
