<?php

namespace App\Http\Traits;

trait StatusTrait
{
    public function status()
    {
        if (!array_key_exists('status', $this->data)) {
            $this->data['status'] = 'pending';
        }
        foreach (tab_langs() as $lang) {
            $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
            $statusField = 'status' . $suffix;
            if (!isset($this->data[$statusField])) {
                $this->data[$statusField] = 'pending';
            } else {
                $this->data[$statusField] = ($this->data[$statusField] == '1' || $this->data[$statusField] === true)
                    ? 'active'
                    : 'pending';
            }
        }
    }

    public function keywords()
    {
        foreach (tab_langs() as $lang) {
            $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
            $statusField = 'keywords' . $suffix;
            $this->data[$statusField] = json_encode($this->data[$statusField]);
        }
    }
    public function attributes()
    {
        foreach (tab_langs() as $lang) {
            $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
            $statusField = 'attributes' . $suffix;
            $this->data[$statusField] = json_encode($this->data[$statusField]);
        }
    }
}