<?php

namespace App\Livewire\Components;

use Livewire\Component;
use Livewire\attributes\On;

class InputField extends Component
{
    public $type = 'text';
    public $label;
    public $model;
    public $required = false;
    public $attributes1 = [];
    public $errors = [];

    public function mount($type = 'text', $label = null, $model = null, $required = false, $attributes1 = [])
    {
        $this->type = $type;
        $this->label = $label;
        $this->model = $model;
        $this->required = $required;
        $this->attributes1 = $attributes1;
        
    }

    #[On('validate-input')]
    public function validateInput($field, $value)
    {
        try {
            if ($this->model === $field) {
                $rules = $this->getRules();
                $this->validateOnly($value, $rules);
                $this->errors = [];
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            $this->errors = $e->errors();
        }
    }

    public function getRules()
    {
        $rules = [];
        if ($this->required) {
            $rules[] = 'required';
        }
        if ($this->type === 'email') {
            $rules[] = 'email';
        } elseif ($this->type === 'number') {
            $rules[] = 'numeric';
        }
        $rules[] = 'max:255';
        return [$this->model => $rules];
    }

    public function render()
    {
        return view('livewire.components.input-field');
    }
}