<?php

namespace App\Livewire\Components;

use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Component;

class TomSelect extends Component
{
    public $options = [];
    public $value = null;
    public $field = '';
    public $isMultiple = false;
    public $required = false;
    public $immediateUpdate = false;
    public $label = '';
    public $placeholder = '';
    public $style = [];
    public $disabled = false;
    public $keyword = false;
    public $uniqueKey;

    public function mount($options, $value = null, $field = '', $isMultiple = false, $required = false, $immediateUpdate = false, $label = '', $placeholder = '', $disabled = false,$keyword = false, $uniqueKey = null, $style = [])
    {
        try {
            $this->options = $options;
            $this->value = $value;
            $this->field = $field;
            $this->isMultiple = $isMultiple;
            $this->required = $required;
            $this->immediateUpdate = $immediateUpdate;
            $this->label = $label;
            $this->placeholder = $placeholder;
            $this->disabled = $disabled;
            $this->keyword = $keyword;
            $this->style = $style;
            $this->uniqueKey = $uniqueKey ?? uniqid('tomselect_');
        } catch (\Exception $e) {
            $this->dispatch('errorShow', icon: 'error', title: 'Error', text: $e->getMessage());
        }
    }
  

    #[Layout('components.layouts.app', [
        'assets' => ['tom-select'],
        'theme' => '7'
    ])]
    public function render()
    {
        return view('livewire.components.tom-select');
    }
}