<?php

namespace App\Livewire\Dashboard\Company\CompanyFaq;

use Illuminate\Support\Facades\DB;
use Livewire\Attributes\Layout;
use Livewire\Component;
use App\Models\CompanyFaq;

class Edit extends Component
{
    public $item;
    public $userId;
    public $translatableFields = [
        'question',
        'answer',
        'status',
    ];
    public $data = [];

    public function mount($id)
    {
        $this->item = CompanyFaq::where('id', $id)
            ->first();
        $this->loadData();
        
    }

    protected function loadData()
    {
        foreach (tab_langs() as $lang) {
            $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
            foreach ($this->translatableFields as $field) {
                $dbField = $field . $suffix;
                $this->data[$dbField] = read_lang($this->item, $field, $lang->lang);
            }
        }
    }


    public function save()
    {
        try {
            $this->validate();
            DB::beginTransaction();

            foreach ($this->data as $key => $value) {
                if (str_starts_with($key, 'status')) {
                    $this->data[$key] = ($value == '' || $value == 'pending') ? 'pending' : 'active';
                }
            }

            $this->item->update([
                'question' => $this->data['question'],
                'answer' => $this->data['answer'],
                'status' => $this->data['status'],
            ]);
            store_lang_for_array_data($this->item, $this->data, ['question', 'answer','status'],'edit');
            DB::commit();
            $this->dispatch('insert', icon: 'success', title: 'Success', text: translateText('The form was submitted successfully.', lang_admin()));
        } catch (\Illuminate\Validation\ValidationException $e) {
            DB::rollBack();
            $messages = $e->validator->errors()->all();
            $errorMessage = implode('<br>', array_map(function ($error) {
                $error = str_replace('data.', '', $error);
                return "- $error";
            }, $messages));
            $this->dispatch('errorShow', icon: 'warning', title: '! Validation Error !', text: $errorMessage);
        } catch (\Exception $e) {
            DB::rollBack();
            $this->dispatch('errorShow', icon: 'error', title: 'Error', text: $e->getMessage());
        }
    }

    #[Layout('components.layouts.app', [
        'assets' => [],
        'theme' => '7'
    ])]
    public function render()
    {
        return view('livewire.dashboard.company.company-faq.edit', [
            'title' => 'Edit Company Faq',
            'page_title' => ['Company', 'Company Faq'],
        ]);
    }

    protected function rules()
    {
        $rules = [
        ];
        foreach (tab_langs() as $lang) {
            $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
            $rules["data.question{$suffix}"] = $lang->status == 'default' ? 'required' : 'nullable';
            $rules["data.answer{$suffix}"] = $lang->status == 'default' ? 'required' : 'nullable';
            $rules["data.status{$suffix}"] = 'nullable|in:1,active,pending';
        }

        return $rules;
    }
}