<?php

namespace App\Livewire\Dashboard\Company\CompanyFaq;

use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Component;
use App\Models\CompanyFaq;

class Manage extends Component
{
    public $items;
    public $userId;
    public $sort = [];

    public function mount($id)
    {
        $this->items = CompanyFaq::where('user_id', $id)->get();
        $this->userId = $id;
        foreach ($this->items as $item) {
            $this->sort[$item->id] = $item->sort;
        }
    }

    #[On('sortUpdate')]
    public function sortUpdate($id,$sort)
    {
        $certificate = CompanyFaq::find($id);
        if ($certificate) {
            $certificate->sort = $sort;
            $certificate->save();
            $this->dispatch('tableRender');
            $this->dispatch('alert', icon: 'success', title: 'Updated');
        }
    }

    #[On('remove')]
    public function remove($id)
    {
        $item = CompanyFaq::findOrFail($id);
        try {
            $this->authorize('delete', $item);
            $item->delete();
            $this->items = CompanyFaq::where('user_id', $this->userId)->get();
            $this->dispatch('tableRender');
            $this->dispatch('insert', icon: 'info', title: 'Deleted', text: 'deleted successfully.');
        } catch (\Exception $e) {
            $this->dispatch('insert', icon: 'error', title: 'Error', text: 'Failed to delete. '.$e->getMessage());
        }
    }

    #[On('itemRender')]
    public function tableRender()
    {
        $this->items = CompanyFaq::where('user_id', $this->userId)->get();
        $this->dispatch('tableRender');
    }

    #[Layout('components.layouts.app', [
        'assets' => ['table'],
        'theme' => '7'
    ])]
    public function render()
    {
        return view('livewire.dashboard.company.company-faq.manage', [
            'title' => 'Manage Company Faq',
            'page_title' => ['Company', 'Company Faq'],
        ]);
    }
}