<?php

namespace App\Livewire\Dashboard\Company;

use App\Models\QualityControl;
use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\DB;

class QualityControlForm extends Component
{
    use WithFileUploads;

    public $baseFields = [
        'text',
    ];
    public $tools;
    public $item;
    public $data = [];
    public function someMethod()
    {
        return $this->tools;
    }
    public function mount($id)
    {
        $this->item = QualityControl::firstOrCreate(['user_id' => $id], ['user_id' => $id]);
        $this->loadData();
    }

    protected function loadData()
    {
        foreach ($this->baseFields as $field) {
            $this->data[$field] = $this->item->$field;
        }
    }
    #[On('ckeditor-updated')]
    public function handleCKEditorUpdated($field, $value)
    {
        try {
            $this->data[$field] = $value;
            \Log::debug('CKEditor updated:', ['field' => $field, 'value' => $value]);
        } catch (\Exception $e) {
            $this->dispatch('errorShow', icon: 'error', title: 'Error', text: 'Failed to handle CKEditor update.');
        }
    }

    public function save()
    {
        $this->dispatch('update-ckeditor-values');
        usleep(300000);
        $this->dispatch('final');
    }

    #[On('final')]
    public function final()
    {
        
        try {
            $this->validate();

            DB::beginTransaction();

            $this->item->update([
                'text' => $this->data['text'],
            ]);
            DB::commit();

            $this->dispatch('insert', icon: 'success', title: 'success', text: translateText('The form was submitted successfully.', lang_admin()));
            $this->loadData();
        } catch (\Illuminate\Validation\ValidationException $e) {
            DB::rollBack();
            if (!$this->item->exists) {
                $this->item->delete();
            }
            $messages = $e->validator->errors()->all();
            $errorMessage = implode('<br>', array_map(function ($error) {
                $error = str_replace('data.', '', $error);
                return "- $error";
            }, $messages));
            $this->dispatch('errorShow', icon: 'warning', title: '! Validation Error !', text: $errorMessage);
        } catch (\Exception $e) {
            DB::rollBack();
            if (!$this->item->exists) {
                $this->item->delete();
            }
            $this->dispatch('errorShow', icon: 'error', title: 'Error', text: translateText('An unexpected error occurred.', lang_admin()));
        }
    }

    #[Layout('components.layouts.app', [
        'assets' => ['editor'],
        'theme' => '7'
    ])]
    public function render()
    {
        return view('livewire.dashboard.company.quality-control-form',
            [
                'title' => 'Edit Quality Control',
                'page_title' => ['Company', 'Quality Control'],
            ]);
    }

    protected function rules()
    {
        $rules = [
            'data.text' => 'required',
        ];

        return $rules;
    }
}