<?php

namespace App\Livewire\Front\Category;

use App\Models\ProductCategory;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;

class Index extends Component
{
    #[Layout('front.layouts.front')]

    #[Computed]
    public function categories()
    {
        return ProductCategory::with(['children.children' => function ($query) {
            $query->checkStatus()->orderBy('sort');
        }])
            ->where('parent_id', null)
            ->checkStatus()
            ->orderBy('sort')
            ->get();
    }

    public function render()
    {
        return view('livewire.front.category.index');
    }
}