<?php
namespace App\Livewire\Front\Category;

use App\Models\ProductCategory;
use Livewire\Attributes\Url;
use Livewire\Component;

class SubcategoryItem extends Component
{
    public ProductCategory $subcategory;

    public string $search = '';

    public function mount(ProductCategory $subcategory)
    {
        $this->subcategory = $subcategory;
    }
    
    public function getFilteredGrandchildrenProperty()
    {
        $grandchildren = $this->subcategory->children;

        if ($this->search) {
            $grandchildren = $grandchildren->filter(function ($grandchild) {
                return stripos($grandchild->title, $this->search) !== false;
            });
        }

        return $grandchildren->sortBy('sort');
    }

    public function render()
    {
        return view('livewire.front.category.subcategory-item');
    }
}