<?php

namespace App\Livewire\Front\Service;

use App\Models\Product;
use App\Models\RequiredServiceUser;
use Livewire\Attributes\Computed;
use Livewire\Component;

class ServiceForm extends Component
{
    public $selectedService = '';

    public $selectedSubService = 'select';

    public $verifiedProviders = false;

    public $serviceName = '';

    public $serviceDescription = '';


    protected function rules()
    {
        return [
            'selectedService' => ['required'],
            'selectedSubService' => ['nullable'],
            'serviceName' => ['nullable', 'string'],
            'serviceDescription' => ['nullable', 'string', 'max:1000'],
        ];
    }

    /* protected function messages()
     {
         return [
             'title.required' => 'عنوان برند الزامی است.',
             'title.min' => 'عنوان برند باید حداقل ۳ کاراکتر باشد.',
             'title.regex' => 'عنوان برند فقط می‌تواند شامل حروف، اعداد، خط تیره، زیرخط و اسلش باشد.',

             'english_title.min' => 'عنوان انگلیسی باید حداقل ۳ کاراکتر باشد.',
             'english_title.regex' => 'عنوان انگلیسی فقط می‌تواند شامل حروف انگلیسی باشد.',
         ];
     }*/


    #[Computed]
    public function services()
    {
        return Product::whereHas('user_active')
            ->checkStatus()
            ->whereHas('c1_service_yes')
            ->orderBy('seen', 'desc')
            ->get();

    }

    #[Computed]
    public function subServices()
    {
        if (!$this->selectedService) {
            return collect();
        }

        $product = Product::with(['c1', 'c2', 'c3', 'c4'])->find($this->selectedService);

        if (!$product) {
            return collect();
        }

        $subs = collect();

        if ($product->c1) $subs->push($product->c1);
        if ($product->c2) $subs->push($product->c2);
        if ($product->c3) $subs->push($product->c3);
        if ($product->c4) $subs->push($product->c4);

        return $subs;
    }

    public function resetForm()
    {
        $this->dispatch('resetPage');
    }

    public function submit()
    {
        if (!auth()->user()) {
            $this->dispatch('alert', icon: 'warning', title: read_lang_word('product-alert'));
            return;
        }

        $this->validate();
        $selectedService = $this->services->where('id', $this->selectedService)->first()?->title ?? '';
        $selectedSubService = $this->subServices->where('id', $this->selectedSubService)->first()?->title ?? '';
        RequiredServiceUser::create([
            'user_id' => auth()->id(),
            'service' => $selectedService,
            'sub_service' => $selectedSubService,
            'verified_providers' => $this->verifiedProviders,
            'keyword' => $this->serviceName,
            'description' => $this->serviceDescription,
        ]);

        $this->dispatch('alert', icon: 'success', title: read_lang_word('msg-success-form'));
    }

    public function render()
    {
        return view('livewire.front.service.service-form', [
            'initialKeywords' => $this->serviceName ? explode(',', $this->serviceName) : []
        ]);
    }
}