<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BusinessInformation extends Model
{
    protected $table = 'business_information';

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $casts = [
        'bussiness_type' => 'array',
        'main_product_keywords' => 'array'
    ];
    public function categories()
    {
        return $this->belongsToMany(ProductCategory::class, 'business_information_categories', 'business_information_id', 'category_id');
    }
    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }
    public function user_active()
    {
        return $this->belongsTo('App\Models\User', 'user_id')->where('status','active');
    }
}