<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class CompanyCertificate extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $table = 'company_certificates';
    protected $casts = [
        'issued_date' => 'datetime',
        'expiry_date' => 'datetime',
    ];

    public function getStatusAttribute($value)
    {
        if ($this->expiry_date && $this->expiry_date->isPast()) {
            return 'expired';
        }
        return $value;
    }
    public function class_fields()
    {
        switch ($this->status) {
            case 'active':
                return 'badge-light-success';
            case 'pending':
                return 'badge-light-warning';
            case 'expired':
                return 'badge-light-info';
            default:
                return 'none';
        }
    }

    public function photo1()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','photo1');
    }

    public function photo2()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','photo2');
    }

    public function photo3()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','photo3');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function user_active()
    {
        return $this->belongsTo('App\Models\User', 'user_id')->where('status','active');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang',app()->getLocale())->where('col_name','status')->where('text','active');
    }

    public function scopeCheckStatus($query)
    {
        if (default_lang() == lang()) {
            return $query->where('status', 'active');
        } else {
            return $query->whereHas('lang_active');
        }
    }

    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($certificate) {
            if($certificate->photo1) {
                if(is_file($certificate->photo1->path)) {
                    File::delete($certificate->photo1->path);
                    delete_directory($certificate->photo1->path);
                }
                $certificate->photo1->delete();
            }
            if($certificate->photo2) {
                if(is_file($certificate->photo2->path)) {
                    File::delete($certificate->photo2->path);
                    delete_directory($certificate->photo2->path);
                }
                $certificate->photo2->delete();
            }
            if($certificate->photo3) {
                if(is_file($certificate->photo3->path)) {
                    File::delete($certificate->photo3->path);
                    delete_directory($certificate->photo3->path);
                }
                $certificate->photo3->delete();
            }
            if(count($certificate->langs)) {
                foreach ($certificate->langs as $lang) {
                    $lang->delete();
                }
            }
        });
    }
}