<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CompanyFaq extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $table = 'company_faqs';


    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function user_active()
    {
        return $this->belongsTo('App\Models\User', 'user_id')->where('status','active');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang',app()->getLocale())->where('col_name','status')->where('text','active');
    }

    public function scopeCheckStatus($query)
    {
        if (default_lang() == lang()) {
            return $query->where('status', 'active');
        } else {
            return $query->whereHas('lang_active');
        }
    }

    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($certificate) {
            if(count($certificate->langs)) {
                foreach ($certificate->langs as $lang) {
                    $lang->delete();
                }
            }
        });
    }
}