<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CompanyForm extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];
    protected $table = 'company_form';

    public static function type_fields($item)
    {
        switch ($item) {
            case 'number_of_emploees':
                $res = 'تعداد کارکنان';
                break;
            case 'payment_terms':
                $res = 'شرایط پرداخت';
                break;
            case 'social_media':
                $res = 'شبکه‌های اجتماعی';
                break;
            case 'contact_person':
                $res = 'شخص رابط';
                break;
            case 'bussiness_type':
                $res = 'نوع کسب‌وکار';
                break;
            case 'ownership_model':
                $res = 'مدل مالکیت';
                break;
            case 'export_revenue':
                $res = 'درآمد صادراتی';
                break;
            case 'annual_turnover':
                $res = 'گردش مالی سالانه';
                break;
            case 'total_capitalization':
                $res = 'سرمایه‌گذاری کل';
                break;
            case 'currencies':
                $res = 'ارزها';
                break;
            case 'days':
                $res = 'روزهای هفته';
                break;
            case 'lang':
                $res = 'زبان';
                break;
            default:
                $res = 'ثبت نشده';
                break;
        }
        return $res;
    }

    public static function color_fields($item)
    {
        switch ($item) {
            case 'number_of_emploees':
                $res = '#FFF0F5';
                break;
            case 'payment_terms':
                $res = '#F0FFF0';
                break;
            case 'social_media':
                $res = '#F0F8FF';
                break;
            case 'contact_person':
                $res = '#FFF8DC';
                break;
            case 'bussiness_type':
                $res = '#FAFAD2';
                break;
            case 'ownership_model':
                $res = '#E6E6FA';
                break;
            case 'export_revenue':
                $res = '#F5F5DC';
                break;
            case 'annual_turnover':
                $res = '#FFE4E1';
                break;
            case 'total_capitalization':
                $res = '#F0FFFF';
                break;
            case 'currencies':
                $res = '#e9ffe0';
                break;
            case 'days':
                $res = '#f3f3f3';
                break;
            case 'lang':
                $res = '#eaf8ff';
                break;
            default:
                $res = '#FFFFFF';
                break;
        }
        return $res;
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang', app()->getLocale())->where('col_name', 'status')->where('text', 'active');
    }

    public function scopeCheckStatus($query)
    {
        if (default_lang() == lang()) {
            return $query->where('status', 'active');
        } else {
            return $query->whereHas('lang_active');
        }
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if (count($item->langs)) {
                foreach ($item->langs as $lang) {
                    $lang->delete();
                }
            }

        });
    }
}
