<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class ContactInformation extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $table = 'contact_information';
    
    public function countries()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }
    public function state()
    {
        return $this->belongsTo(State::class, 'state_id');
    }
    public function city()
    {
        return $this->belongsTo(City::class, 'city_id');
    }

    public function profile()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','profile');
    }
    
    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }
    public function user_active()
    {
        return $this->belongsTo('App\Models\User', 'user_id')->where('status','active');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang',app()->getLocale())->where('col_name','status')->where('text','active');
    }
    public function scopeCheckStatus($query)
    {
        if (default_lang() == lang()) {
            return $query->where('status', 'active');
        } else {
            return $query->whereHas('lang_active');
        }
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if($item->profile)
            {
                if(is_file($item->profile->path))
                {
                    File::delete($item->profile->path);
                    delete_directory($item->profile->path);
                }
                $item->profile->delete();
            }
            if(count($item->langs))
            {
                foreach ($item->langs as $lang)
                {
                    $lang->delete();
                }
            }
        });
    }
}
