<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class FactoryInformation extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $table = 'factory_information';

    public function gallery()
    {
        return $this->morphMany('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'gallery');
    }

    public function video()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'video');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }
    public function user_active()
    {
        return $this->belongsTo('App\Models\User', 'user_id')->where('status','active');
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if (count($item->gallery)) {
                foreach ($item->gallery as $photo) {
                    if (is_file($photo->path)) {
                        File::delete($photo->path);
                        delete_directory($photo->path);
                    }
                    $photo->delete();
                }
            }

            if ($item->video) {
                if (is_file($item->video->path)) {
                    File::delete($item->video->path);
                    delete_directory($item->video->path);
                }
                $item->video->delete();
            }
        });
    }
}