<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Feedback extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];
    protected $table = 'feed_backs';

    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'photo');
    }

    public function video()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'video');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if ($item->photo) {
                if (is_file($item->photo->path)) {
                    File::delete($item->photo->path);
                    delete_directory($item->photo->path);
                }
                $item->photo->delete();
            }
            if ($item->video) {
                if (is_file($item->video->path)) {
                    File::delete($item->video->path);
                    delete_directory($item->video->path);
                }
                $item->video->delete();
            }
        });
    }
}
